/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.geometric.PGpoint;
import org.revenj.postgres.PostgresBuffer;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.DoubleConverter;
import org.revenj.postgres.converters.IntConverter;
import org.revenj.postgres.converters.PostgresTuple;

public abstract class PointConverter {
    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, Point2D value) throws SQLException {
        PGpoint pg = new PGpoint(value.getX(), value.getY());
        ps.setObject(index, pg);
    }

    public static void serializeURI(PostgresBuffer sw, Point2D value) {
        sw.addToBuffer('(');
        sw.addToBuffer(Double.toString(value.getX()));
        sw.addToBuffer(',');
        sw.addToBuffer(Double.toString(value.getY()));
        sw.addToBuffer(')');
    }

    public static Point parsePoint(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : new Point();
        }
        Point res = PointConverter.parsePoint(reader, context);
        reader.read();
        return res;
    }

    public static Point2D parseLocation(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : new Point2D.Double();
        }
        Point2D res = PointConverter.parseLocation(reader, context);
        reader.read();
        return res;
    }

    private static Point parsePoint(PostgresReader reader, int context) throws IOException {
        reader.read(context);
        int x = IntConverter.parse(reader);
        int y = IntConverter.parse(reader);
        reader.read(context);
        return new Point(x, y);
    }

    private static Point2D parseLocation(PostgresReader reader, int context) throws IOException {
        reader.read(context);
        double x = DoubleConverter.parse(reader);
        double y = DoubleConverter.parse(reader);
        reader.read(context);
        return new Point2D.Double(x, y);
    }

    public static List<Point> parsePointCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        int innerContext = context == 0 ? 1 : context << 1;
        cur = reader.peek();
        if (cur == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Point>(0);
        }
        ArrayList<Point> list = new ArrayList<Point>();
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read(4);
                if (allowNulls) {
                    list.add(null);
                    continue;
                }
                list.add(new Point());
                continue;
            }
            list.add(PointConverter.parsePoint(reader, innerContext));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static List<Point2D> parseLocationCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        int innerContext = context == 0 ? 1 : context << 1;
        cur = reader.peek();
        if (cur == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Point2D>(0);
        }
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read(4);
                if (allowNulls) {
                    list.add(null);
                    continue;
                }
                list.add(new Point2D.Double());
                continue;
            }
            list.add(PointConverter.parseLocation(reader, innerContext));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(Point2D value) {
        if (value == null) {
            return null;
        }
        return new PointTuple(value);
    }

    static class PointTuple
    extends PostgresTuple {
        private final Point2D value;

        public PointTuple(Point2D value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return true;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write('(');
            sw.write(Double.toString(this.value.getX()));
            sw.write(',');
            sw.write(Double.toString(this.value.getY()));
            sw.write(')');
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            this.insertRecord(sw, escaping, mappings);
        }

        @Override
        public String buildTuple(boolean quote) {
            if (quote) {
                return "'(" + this.value.getX() + "," + this.value.getY() + ")'";
            }
            return "(" + this.value.getX() + "," + this.value.getY() + ")";
        }
    }
}

