/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.jpqlquery;

import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.postgres.jinq.jpqlquery.QueryGenerationState;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;

public class SubqueryExpression
extends Expression {
    SelectFromWhere<?> subquery;

    public static SubqueryExpression from(SelectFromWhere<?> subquery) {
        SubqueryExpression expr = new SubqueryExpression();
        expr.subquery = subquery;
        return expr;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        OperatorPrecedenceLevel precedence = OperatorPrecedenceLevel.JPQL_ORDER_BY_UNRESTRICTED_OPERATOR_PRECEDENCE;
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery("(");
        }
        this.subquery.generateQueryContents(queryState);
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery(")");
        }
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.subquery.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SubqueryExpression o = (SubqueryExpression)obj;
        return this.subquery.equals(o.subquery);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitSubquery(this);
    }
}

