/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.Arrays;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.GroupedSelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.RowReader;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.jpqlquery.TupleRowReader;
import org.revenj.postgres.jinq.transform.GroupingLambdasArgumentHandler;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjMultiLambdaQueryTransform;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SelectTransform;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExToColumns;

public class GroupingTransform
extends RevenjMultiLambdaQueryTransform {
    public GroupingTransform(RevenjQueryTransformConfiguration config) {
        super(config);
    }

    private <U, V, W> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis groupingLambda, LambdaAnalysis[] lambdas, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SelectTransform keyTransform = new SelectTransform(this.config, false);
                JinqPostgresQuery keyQuery = keyTransform.apply(query, groupingLambda, parentArgumentScope);
                if (!keyQuery.isSelectFromWhere()) {
                    throw new QueryTransformException("Expecting the result of the key calculation to be a SelectFromWhere query");
                }
                SelectOnly keySelect = new SelectOnly();
                keySelect.cols = ((SelectFromWhere)keyQuery).cols;
                SelectOnly streamTee = new SelectOnly();
                streamTee.cols = sfw.cols;
                ColumnExpressions[] aggregatedQueryEntries = new ColumnExpressions[lambdas.length];
                for (int n = 0; n < lambdas.length; ++n) {
                    ColumnExpressions returnQuery;
                    LambdaAnalysis lambda = lambdas[n];
                    SymbExToColumns translator = this.config.newSymbExToColumns(new GroupingLambdasArgumentHandler(keySelect, streamTee, lambdas[n], this.config.metamodel, parentArgumentScope, false));
                    aggregatedQueryEntries[n] = returnQuery = this.makeSelectExpression(translator, lambda);
                }
                GroupedSelectFromWhere toReturn = sfw.shallowCopyWithGrouping();
                toReturn.isAggregated = true;
                RowReader[] readers = new RowReader[aggregatedQueryEntries.length + 1];
                for (int n = 0; n < aggregatedQueryEntries.length; ++n) {
                    readers[n + 1] = aggregatedQueryEntries[n].reader;
                }
                readers[0] = keySelect.getRowReader();
                ColumnExpressions<U> cols = new ColumnExpressions<U>(this.createTupleReader(readers));
                cols.columns.addAll(keySelect.cols.columns);
                for (int n = 0; n < aggregatedQueryEntries.length; ++n) {
                    cols.columns.addAll(aggregatedQueryEntries[n].columns);
                }
                toReturn.groupingCols = keySelect.cols;
                toReturn.cols = cols;
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createTupleReader(RowReader<?>[] readers) {
        return TupleRowReader.createReaderForTuple(readers);
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis[] lambdas, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        return this.apply(query, lambdas[0], Arrays.copyOfRange(lambdas, 1, lambdas.length), parentArgumentScope);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return GroupingTransform.class.getName();
    }
}

