/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.From;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.ReadFieldExpression;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.transform.JoinTransform;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.OuterJoinTransform;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjOneLambdaQueryTransform;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SelectFromWhereLambdaArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExPassDown;
import org.revenj.postgres.jinq.transform.SymbExToSubQuery;

public class JoinFetchTransform
extends RevenjOneLambdaQueryTransform {
    boolean isExpectingStream;
    boolean isOuterJoinFetch;

    public JoinFetchTransform(RevenjQueryTransformConfiguration config, boolean isExpectingStream, boolean isOuterJoinFetch) {
        super(config);
        this.isExpectingStream = isExpectingStream;
        this.isOuterJoinFetch = isOuterJoinFetch;
    }

    public JoinFetchTransform(RevenjQueryTransformConfiguration config) {
        this(config, false, false);
    }

    public JoinFetchTransform setIsExpectingStream(boolean isExpectingStream) {
        this.isExpectingStream = isExpectingStream;
        return this;
    }

    public JoinFetchTransform setIsOuterJoinFetch(boolean isOuterJoinFetch) {
        this.isOuterJoinFetch = isOuterJoinFetch;
        return this;
    }

    private static boolean isJoinFetchCompatible(SelectFromWhere<?> toMerge) {
        From from = toMerge.froms.get(0);
        if (!(from instanceof From.FromNavigationalLinks)) {
            return false;
        }
        Expression navLink = ((From.FromNavigationalLinks)from).links;
        return navLink instanceof ReadFieldExpression;
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, false), this.isExpectingStream);
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JinqPostgresQuery returnExpr = (JinqPostgresQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods(), this.config.getStaticComparisonMethods(), (boolean)this.config.isAllEqualsSafe).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    From from = toMerge.froms.get(0);
                    if (!JoinFetchTransform.isJoinFetchCompatible(toMerge)) {
                        throw new QueryTransformException("Join fetch must be a single navigational link");
                    }
                    From.FromNavigationalLinksGeneric joinFetchFrom = this.isOuterJoinFetch ? From.forNavigationalLinksLeftOuterJoinFetch((From.FromNavigationalLinks)from) : From.forNavigationalLinksJoinFetch((From.FromNavigationalLinks)from);
                    ((SelectFromWhere)toReturn).froms.add(joinFetchFrom);
                    OuterJoinTransform.rewriteFromAliases(toMerge, from, joinFetchFrom);
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return JoinFetchTransform.class.getName();
    }
}

