/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.revenj.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.postgres.jinq.jpqlquery.Expression;
import org.revenj.postgres.jinq.jpqlquery.From;
import org.revenj.postgres.jinq.jpqlquery.FromAliasExpression;
import org.revenj.postgres.jinq.jpqlquery.JinqPostgresQuery;
import org.revenj.postgres.jinq.jpqlquery.ReadFieldExpression;
import org.revenj.postgres.jinq.jpqlquery.RecursiveExpressionVisitor;
import org.revenj.postgres.jinq.jpqlquery.RowReader;
import org.revenj.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.postgres.jinq.jpqlquery.TupleRowReader;
import org.revenj.postgres.jinq.transform.JoinTransform;
import org.revenj.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.postgres.jinq.transform.QueryTransformException;
import org.revenj.postgres.jinq.transform.RevenjOneLambdaQueryTransform;
import org.revenj.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.postgres.jinq.transform.SelectFromWhereLambdaArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExArgumentHandler;
import org.revenj.postgres.jinq.transform.SymbExPassDown;
import org.revenj.postgres.jinq.transform.SymbExToSubQuery;

public class OuterJoinTransform
extends RevenjOneLambdaQueryTransform {
    boolean isExpectingStream;
    boolean isJoinFetch;

    public OuterJoinTransform(RevenjQueryTransformConfiguration config, boolean isExpectingStream, boolean isJoinFetch) {
        super(config);
        this.isExpectingStream = isExpectingStream;
        this.isJoinFetch = isJoinFetch;
    }

    public OuterJoinTransform(RevenjQueryTransformConfiguration config) {
        this(config, true, false);
    }

    public OuterJoinTransform setIsExpectingStream(boolean isExpectingStream) {
        this.isExpectingStream = isExpectingStream;
        return this;
    }

    public OuterJoinTransform setIsJoinFetch(boolean isJoinFetch) {
        this.isJoinFetch = isJoinFetch;
        return this;
    }

    static boolean isChainedLink(Expression links) {
        if (links instanceof ReadFieldExpression) {
            return ((ReadFieldExpression)links).base instanceof ReadFieldExpression;
        }
        return false;
    }

    static boolean isLeftOuterJoinCompatible(SelectFromWhere<?> toMerge) {
        From from = toMerge.froms.get(0);
        if (!(from instanceof From.FromNavigationalLinks)) {
            return false;
        }
        Expression navLink = ((From.FromNavigationalLinks)from).links;
        while (!(navLink instanceof FromAliasExpression)) {
            if (!(navLink instanceof ReadFieldExpression)) {
                return false;
            }
            navLink = ((ReadFieldExpression)navLink).base;
        }
        return true;
    }

    static void rewriteFromAliases(SelectFromWhere<?> toMerge, final From oldFrom, final From newFrom) {
        for (Expression expr : toMerge.cols.columns) {
            expr.visit(new RecursiveExpressionVisitor(){

                @Override
                public void visitFromAlias(FromAliasExpression expr) {
                    if (expr.from == oldFrom) {
                        expr.from = newFrom;
                    }
                    super.visitFromAlias(expr);
                }
            });
        }
    }

    @Override
    public <U, V> JinqPostgresQuery<U> apply(JinqPostgresQuery<V> query, LambdaAnalysis lambda, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.isSelectFromWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                SymbExToSubQuery translator = this.config.newSymbExToSubQuery(SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, lambda, this.config.metamodel, parentArgumentScope, false), this.isExpectingStream);
                if (lambda.symbolicAnalysis.paths.size() > 1) {
                    throw new QueryTransformException("Can only handle a single path in a JOIN at the moment");
                }
                SymbExPassDown passdown = SymbExPassDown.with(null, false);
                JinqPostgresQuery returnExpr = (JinqPostgresQuery)PathAnalysisSimplifier.simplify((TypedValue)((PathAnalysis)lambda.symbolicAnalysis.paths.get(0)).getReturnValue(), this.config.getComparisonMethods(), this.config.getStaticComparisonMethods(), (boolean)this.config.isAllEqualsSafe).visit((TypedValueVisitor)translator, (Object)passdown);
                if (JoinTransform.isSimpleFrom(returnExpr)) {
                    SelectFromWhere toMerge = (SelectFromWhere)returnExpr;
                    SelectOnly toReturn = sfw.shallowCopy();
                    From from = toMerge.froms.get(0);
                    if (!OuterJoinTransform.isLeftOuterJoinCompatible(toMerge)) {
                        throw new QueryTransformException("Left outer join must be applied to a navigational link");
                    }
                    From.FromNavigationalLinksGeneric outerJoinFrom = this.isJoinFetch ? From.forNavigationalLinksLeftOuterJoinFetch((From.FromNavigationalLinks)from) : From.forNavigationalLinksLeftOuterJoin((From.FromNavigationalLinks)from);
                    if (!this.isJoinFetch && OuterJoinTransform.isChainedLink(outerJoinFrom.links)) {
                        ReadFieldExpression outerLinks = (ReadFieldExpression)outerJoinFrom.links;
                        From baseFrom = From.forNavigationalLinks(outerLinks.base);
                        ((SelectFromWhere)toReturn).froms.add(baseFrom);
                        outerJoinFrom.links = new ReadFieldExpression(new FromAliasExpression(baseFrom), outerLinks.field);
                    }
                    ((SelectFromWhere)toReturn).froms.add(outerJoinFrom);
                    OuterJoinTransform.rewriteFromAliases(toMerge, from, outerJoinFrom);
                    ((SelectFromWhere)toReturn).cols = new ColumnExpressions<U>(this.createPairReader(sfw.cols.reader, toMerge.cols.reader));
                    ((SelectFromWhere)toReturn).cols.columns.addAll(sfw.cols.columns);
                    ((SelectFromWhere)toReturn).cols.columns.addAll(toMerge.cols.columns);
                    return toReturn;
                }
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    protected <U> RowReader<U> createPairReader(RowReader<?> a, RowReader<?> b) {
        return TupleRowReader.createReaderForTuple(TupleRowReader.PAIR_CLASS, a, b);
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return OuterJoinTransform.class.getName();
    }
}

