/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.security;

import java.io.Closeable;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Query;
import org.revenj.patterns.Specification;
import org.revenj.security.UserPrincipal;

public interface PermissionManager {
    public static final ThreadLocal<Principal> boundPrincipal = new ThreadLocal();

    public boolean canAccess(String var1, Principal var2);

    default public boolean canAccess(Class<?> manifest, Principal user) {
        return this.canAccess(manifest.getTypeName(), user);
    }

    public <T extends DataSource, S extends T> Query<S> applyFilters(Class<T> var1, Principal var2, Query<S> var3);

    default public <T extends DataSource, S extends T> Query<S> applyFilters(Class<T> manifest, Query<S> data) {
        return this.applyFilters(manifest, boundPrincipal.get(), data);
    }

    public <T extends DataSource, S extends T> List<S> applyFilters(Class<T> var1, Principal var2, List<S> var3);

    default public <T extends DataSource, S extends T> List<S> applyFilters(Class<T> manifest, List<S> data) {
        return this.applyFilters(manifest, boundPrincipal.get(), data);
    }

    public <T extends DataSource> Closeable registerFilter(Class<T> var1, Specification<T> var2, String var3, boolean var4);

    default public <T extends DataSource> Closeable registerForRole(Class<T> manifest, Specification<T> filter, String role) {
        return this.registerFilter(manifest, filter, role, false);
    }

    default public <T extends DataSource> Closeable registerWhenNotInRole(Class<T> manifest, Specification<T> filter, String role) {
        return this.registerFilter(manifest, filter, role, true);
    }

    public static boolean implies(String role) {
        Principal principal = boundPrincipal.get();
        if (principal instanceof UserPrincipal) {
            return ((UserPrincipal)principal).implies(role);
        }
        return principal != null && Objects.equals(role, principal.getName());
    }
}

