/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;

public abstract class Guards {
    private static final Comparator<BigDecimal> bigDecimalComparator = new Comparator<BigDecimal>(){

        @Override
        public int compare(BigDecimal left, BigDecimal right) {
            return left == null && right == null ? 0 : (left == null ? -1 : (right == null ? 1 : left.compareTo(right)));
        }
    };

    public static <T> void checkNulls(Iterable<T> values) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (T value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Element at index " + i + " was a null value, which is not permitted.");
            }
            ++i;
        }
    }

    public static <T> void checkNulls(T[] values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new IllegalArgumentException("Element at index " + i + " was a null value, which is not permitted.");
        }
    }

    public static <T> void checkNulls(List<T> values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) != null) continue;
            throw new IllegalArgumentException("Element at index " + i + " was a null value, which is not permitted.");
        }
    }

    public static <T> void checkNulls(LinkedList<T> values) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Element at index " + i + " was a null value, which is not permitted.");
            }
            ++i;
        }
    }

    public static void checkScale(BigDecimal value, int scale) {
        if (value == null) {
            return;
        }
        try {
            value.setScale(scale);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Decimal places allowed: " + scale + ". Value: " + value, e);
        }
    }

    public static void checkScale(BigDecimal[] values, int scale) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            BigDecimal value = values[i];
            if (value == null) continue;
            try {
                value.setScale(scale);
                continue;
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Decimal places allowed: " + scale + ". Value: " + value, e);
            }
        }
    }

    public static void checkScale(List<BigDecimal> values, int scale) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            BigDecimal value = values.get(i);
            if (value == null) continue;
            try {
                value.setScale(scale);
                continue;
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Decimal places allowed: " + scale + ". Value: " + value, e);
            }
        }
    }

    public static void checkScale(LinkedList<BigDecimal> values, int scale) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (BigDecimal value : values) {
            try {
                if (value != null) {
                    value.setScale(scale);
                }
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Decimal places allowed: " + scale + ". Value: " + value, e);
            }
            ++i;
        }
    }

    public static void checkScale(Iterable<BigDecimal> values, int scale) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (BigDecimal value : values) {
            try {
                if (value != null) {
                    value.setScale(scale);
                }
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Decimal places allowed: " + scale + ". Value: " + value, e);
            }
            ++i;
        }
    }

    public static BigDecimal setScale(BigDecimal value, int scale) {
        return value.setScale(scale, 4);
    }

    public static Set<BigDecimal> setScale(Set<BigDecimal> values, int scale) {
        if (values == null) {
            return null;
        }
        HashSet<BigDecimal> result = new HashSet<BigDecimal>(values.size());
        for (BigDecimal value : values) {
            result.add(value != null ? Guards.setScale(value, scale) : null);
        }
        return result;
    }

    public static BigDecimal[] setScale(BigDecimal[] values, int scale) {
        if (values == null) {
            return null;
        }
        BigDecimal[] result = new BigDecimal[values.length];
        for (int i = 0; i < values.length; ++i) {
            BigDecimal value = values[i];
            result[i] = value != null ? Guards.setScale(value, scale) : null;
        }
        return result;
    }

    public static List<BigDecimal> setScale(List<BigDecimal> values, int scale) {
        if (values == null) {
            return null;
        }
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            BigDecimal value = values.get(i);
            result.add(value != null ? Guards.setScale(value, scale) : null);
        }
        return result;
    }

    public static Stack<BigDecimal> setScale(Stack<BigDecimal> values, int scale) {
        if (values == null) {
            return null;
        }
        Stack<BigDecimal> result = new Stack<BigDecimal>();
        for (int i = 0; i < values.size(); ++i) {
            BigDecimal value = (BigDecimal)values.get(i);
            result.add(value != null ? Guards.setScale(value, scale) : null);
        }
        return result;
    }

    public static Vector<BigDecimal> setScale(Vector<BigDecimal> values, int scale) {
        if (values == null) {
            return null;
        }
        Vector<BigDecimal> result = new Vector<BigDecimal>();
        for (int i = 0; i < values.size(); ++i) {
            BigDecimal value = values.get(i);
            result.add(value != null ? Guards.setScale(value, scale) : null);
        }
        return result;
    }

    public static Queue<BigDecimal> setScale(Queue<BigDecimal> values, int scale) {
        if (values == null) {
            return null;
        }
        ArrayDeque<BigDecimal> result = new ArrayDeque<BigDecimal>();
        for (BigDecimal value : values) {
            if (value == null) {
                throw new NullPointerException("Default Queue implementation (java.util.ArrayDeque) does not support null elements!");
            }
            result.add(Guards.setScale(value, scale));
        }
        return result;
    }

    public static LinkedList<BigDecimal> setScale(LinkedList<BigDecimal> values, int scale) {
        if (values == null) {
            return null;
        }
        LinkedList<BigDecimal> result = new LinkedList<BigDecimal>();
        for (BigDecimal value : values) {
            result.add(value != null ? Guards.setScale(value, scale) : null);
        }
        return result;
    }

    public static void checkLength(String value, int length) {
        if (value != null && value.length() > length) {
            throw new IllegalArgumentException("Maximum length allowed: " + length + ". Value: " + value);
        }
    }

    public static void checkLength(Iterable<String> values, int length) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (String value : values) {
            if (value != null && value.length() > length) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Maximum length allowed: " + length + ". Value: " + value);
            }
            ++i;
        }
    }

    public static void checkLength(String[] values, int length) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value == null || value.length() <= length) continue;
            throw new IllegalArgumentException("Invalid value for element at index " + i + ". Maximum length allowed: " + length + ". Value: " + value);
        }
    }

    public static void checkLength(List<String> values, int length) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (value == null || value.length() <= length) continue;
            throw new IllegalArgumentException("Invalid value for element at index " + i + ". Maximum length allowed: " + length + ". Value: " + value);
        }
    }

    public static void checkLength(LinkedList<String> values, int length) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (String value : values) {
            if (value != null && value.length() > length) {
                throw new IllegalArgumentException("Invalid value for element at index " + i + ". Maximum length allowed: " + length + ". Value: " + value);
            }
            ++i;
        }
    }

    public static boolean compareBigDecimal(Iterable<BigDecimal> left, Iterable<BigDecimal> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Iterator<BigDecimal> leftIterator = left.iterator();
        Iterator<BigDecimal> rightIterator = right.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            BigDecimal r;
            BigDecimal l = leftIterator.next();
            if (l == (r = rightIterator.next()) || l != null && r != null && l.compareTo(r) == 0) continue;
            return false;
        }
        return leftIterator.hasNext() == rightIterator.hasNext();
    }

    public static boolean compareBigDecimal(BigDecimal[] left, BigDecimal[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            BigDecimal l = left[i];
            BigDecimal r = right[i];
            if (l == r || l != null && r != null && l.compareTo(r) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBigDecimal(Set<BigDecimal> left, Set<BigDecimal> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        BigDecimal[] leftSorted = left.toArray(new BigDecimal[left.size()]);
        Arrays.sort(leftSorted, bigDecimalComparator);
        BigDecimal[] rightSorted = right.toArray(new BigDecimal[right.size()]);
        Arrays.sort(rightSorted, bigDecimalComparator);
        return Guards.compareBigDecimal(leftSorted, rightSorted);
    }

    public static boolean compareBinary(Iterable<byte[]> left, Iterable<byte[]> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Iterator<byte[]> leftIterator = left.iterator();
        Iterator<byte[]> rightIterator = right.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            byte[] r;
            byte[] l = leftIterator.next();
            if (Arrays.equals(l, r = rightIterator.next())) continue;
            return false;
        }
        return leftIterator.hasNext() == rightIterator.hasNext();
    }

    public static boolean compareBinary(byte[][] left, byte[][] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (Arrays.equals(left[i], right[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBinary(Set<byte[]> left, Set<byte[]> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        block0: for (byte[] l : left) {
            for (byte[] r : right) {
                if (!Arrays.equals(l, r)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static <T> boolean compareQueue(Queue<T> left, Queue<T> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Iterator leftIterator = left.iterator();
        Iterator rightIterator = right.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            Object r;
            Object l = leftIterator.next();
            if (l == (r = rightIterator.next()) || l != null && r != null && l.equals(r)) continue;
            return false;
        }
        return leftIterator.hasNext() == rightIterator.hasNext();
    }

    public static boolean compareXml(Iterable<Element> left, Iterable<Element> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Iterator<Element> leftIterator = left.iterator();
        Iterator<Element> rightIterator = right.iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            Element r;
            Element l = leftIterator.next();
            if (l == (r = rightIterator.next()) || l != null && r != null && l.isEqualNode(r)) continue;
            return false;
        }
        return leftIterator.hasNext() == rightIterator.hasNext();
    }

    public static boolean compareXml(Element[] left, Element[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            Element l = left[i];
            Element r = right[i];
            if (l == r || l != null && r != null && l.isEqualNode(r)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareXml(Set<Element> left, Set<Element> right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.size() != right.size()) {
            return false;
        }
        block0: for (Element l : left) {
            for (Element r : right) {
                if (l != r && (l == null || r == null || !l.isEqualNode(r))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean[] toBooleanArray(List<Boolean> items) {
        if (items == null) {
            return null;
        }
        boolean[] result = new boolean[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            result[i] = items.get(i);
        }
        return result;
    }

    public static int[] toInt32Array(List<Integer> items) {
        if (items == null) {
            return null;
        }
        int[] result = new int[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            result[i] = items.get(i);
        }
        return result;
    }

    public static long[] toInt64Array(List<Long> items) {
        if (items == null) {
            return null;
        }
        long[] result = new long[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            result[i] = items.get(i);
        }
        return result;
    }

    public static float[] toFloatArray(List<Float> items) {
        if (items == null) {
            return null;
        }
        float[] result = new float[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            result[i] = items.get(i).floatValue();
        }
        return result;
    }

    public static double[] toDoubleArray(List<Double> items) {
        if (items == null) {
            return null;
        }
        double[] result = new double[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            result[i] = items.get(i);
        }
        return result;
    }
}

