/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.OlapCubeQuery;
import org.revenj.patterns.RepositoryBulkReader;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.postgres.BulkReaderQuery;
import org.revenj.postgres.BulkRepository;
import org.revenj.postgres.PostgresOlapCubeQuery;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.ArrayTuple;
import org.revenj.postgres.jinq.RevenjQueryComposer;
import org.revenj.postgres.jinq.jpqlquery.GeneratedQueryParameter;
import org.revenj.postgres.jinq.transform.LambdaInfo;

class PostgresBulkReader
implements RepositoryBulkReader,
BulkReaderQuery,
AutoCloseable {
    private final ServiceLocator locator;
    private final Connection connection;
    private final PostgresReader reader;
    private final PostgresWriter writer;
    private final StringBuilder builder;
    private final List<Consumer<PreparedStatement>> writeArguments = new ArrayList<Consumer<PreparedStatement>>();
    private int totalArguments;
    private final List<BiFunction<ResultSet, Integer, Object>> resultActions = new ArrayList<BiFunction<ResultSet, Integer, Object>>();
    private Object[] results;
    private final Map<Class<?>, BulkRepository> repositories = new HashMap();
    private final Map<Class<?>, PostgresOlapCubeQuery> cubes = new HashMap();
    private final boolean closeConnection;

    public PostgresBulkReader(ServiceLocator locator, Connection connection, boolean closeConnection) {
        this.locator = locator;
        this.connection = connection;
        this.closeConnection = closeConnection;
        this.reader = PostgresReader.create(locator);
        this.writer = PostgresWriter.create();
        this.builder = new StringBuilder("SELECT (");
    }

    public static PostgresBulkReader create(ServiceLocator locator) {
        Connection connection;
        Optional<Connection> tryConnection = locator.tryResolve(Connection.class);
        boolean closeConnection = tryConnection.isPresent();
        if (!closeConnection) {
            javax.sql.DataSource ds = locator.resolve(javax.sql.DataSource.class);
            try {
                connection = ds.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        } else {
            connection = tryConnection.get();
        }
        return new PostgresBulkReader(locator, connection, closeConnection);
    }

    @Override
    public PostgresReader getReader() {
        return this.reader;
    }

    @Override
    public PostgresWriter getWriter() {
        return this.writer;
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public int getArgumentIndex() {
        return this.totalArguments + 1;
    }

    @Override
    public void reset() {
        this.writer.reset();
        this.builder.setLength(0);
        this.resultActions.clear();
        this.writeArguments.clear();
        this.totalArguments = 0;
        this.results = null;
        this.builder.append("SELECT (");
    }

    @Override
    public void addArgument(Consumer<PreparedStatement> statement) {
        this.writeArguments.add(statement);
        ++this.totalArguments;
    }

    private <T> Callable<T> add(BiFunction<ResultSet, Integer, T> reader) {
        this.builder.append("),(");
        int i = this.resultActions.size();
        this.resultActions.add(reader::apply);
        return () -> {
            if (this.results == null) {
                this.execute();
            }
            return this.results[i];
        };
    }

    private BulkRepository getRepository(Class<?> manifest) {
        BulkRepository repository = this.repositories.get(manifest);
        if (repository == null) {
            try {
                repository = this.locator.resolve(BulkRepository.class, manifest, new Type[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Specified type: " + manifest + " doesn't support bulk reading", e);
            }
            this.repositories.put(manifest, repository);
        }
        return repository;
    }

    private <TSource extends DataSource, TCube extends OlapCubeQuery<TSource>> PostgresOlapCubeQuery<TSource> getCube(Class<TCube> manifest) {
        PostgresOlapCubeQuery cube = this.cubes.get(manifest);
        if (cube == null) {
            cube = (PostgresOlapCubeQuery)this.locator.resolve(manifest);
            this.cubes.put(manifest, cube);
        }
        return cube;
    }

    @Override
    public <T extends Identifiable> Callable<Optional<T>> find(Class<T> manifest, String uri) {
        return this.add(this.getRepository(manifest).find((BulkReaderQuery)this, uri));
    }

    @Override
    public <T extends Identifiable> Callable<List<T>> find(Class<T> manifest, String[] uri) {
        return this.add(this.getRepository(manifest).find((BulkReaderQuery)this, uri));
    }

    @Override
    public <T extends DataSource> Callable<List<T>> search(Class<T> manifest, Specification<T> filter, Integer limit, Integer offset) {
        return this.add(this.getRepository(manifest).search(this, filter, limit, offset));
    }

    @Override
    public <T extends DataSource> Callable<Long> count(Class<T> manifest, Specification<T> filter) {
        return this.add(this.getRepository(manifest).count(this, filter));
    }

    @Override
    public <T extends DataSource> Callable<Boolean> exists(Class<T> manifest, Specification<T> filter) {
        return this.add(this.getRepository(manifest).exists(this, filter));
    }

    @Override
    public <TSource extends DataSource, TCube extends OlapCubeQuery<TSource>> Callable<List<Map<String, Object>>> analyze(Class<TCube> manifest, List<String> dimensionsAndFacts, Collection<Map.Entry<String, Boolean>> order, Specification<TSource> filter, Integer limit, Integer offset) {
        int x;
        PostgresOlapCubeQuery<TSource> cube = this.getCube(manifest);
        this.builder.append("SELECT array_agg(_x) FROM (");
        ArrayList<String> dimensions = new ArrayList<String>(dimensionsAndFacts.size());
        ArrayList<String> facts = new ArrayList<String>(dimensionsAndFacts.size());
        for (String dof : dimensionsAndFacts) {
            if (cube.getDimensions().contains(dof)) {
                dimensions.add(dof);
                continue;
            }
            facts.add(dof);
        }
        ArrayList<GeneratedQueryParameter> parameters = filter != null ? new ArrayList<GeneratedQueryParameter>() : null;
        ArrayList<LambdaInfo> lambdas = filter != null ? new ArrayList<LambdaInfo>(1) : null;
        cube.prepareSql(this.builder, dimensions, facts, order, filter, limit, offset, parameters, lambdas);
        PostgresOlapCubeQuery.Converter[] converters = cube.prepareConverters(dimensions, facts);
        String[] columnNames = new String[dimensionsAndFacts.size()];
        for (x = 0; x < dimensions.size(); ++x) {
            columnNames[x] = (String)dimensions.get(x);
        }
        for (x = 0; x < facts.size(); ++x) {
            columnNames[dimensions.size() + x] = (String)facts.get(x);
        }
        this.builder.append(") _x),(");
        int i = this.resultActions.size();
        ArrayList result = new ArrayList();
        int args = this.getArgumentIndex();
        this.writeArguments.add(ps -> {
            try {
                RevenjQueryComposer.fillQueryParameters(this.connection, this.locator, ps, args, parameters, lambdas);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        this.totalArguments += parameters != null ? parameters.size() : 0;
        this.resultActions.add((rs, ind) -> {
            try {
                this.reader.process(rs.getString((int)ind));
                ArrayTuple.parse(this.reader, 0, (rdr, outCtx, ctx) -> {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    rdr.read(3);
                    for (int x = 0; x < converters.length; ++x) {
                        map.put(columnNames[x], converters[x].convert(rdr));
                    }
                    rdr.read(3);
                    result.add(map);
                    return map;
                });
                return result;
            }
            catch (IOException | SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
        return () -> {
            if (this.results == null) {
                this.execute();
            }
            return result;
        };
    }

    @Override
    public void execute() throws IOException {
        this.results = new Object[this.resultActions.size()];
        try (PreparedStatement ps = this.connection.prepareStatement(this.builder.substring(0, this.builder.length() - 2));){
            for (Consumer<PreparedStatement> writeArgument : this.writeArguments) {
                writeArgument.accept(ps);
            }
            ps.setEscapeProcessing(false);
            ResultSet rs = ps.executeQuery();
            rs.next();
            for (int i = 0; i < this.resultActions.size(); ++i) {
                this.results[i] = this.resultActions.get(i).apply(rs, i + 1);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closeConnection) {
            this.connection.close();
        }
        this.reader.close();
        this.writer.close();
    }
}

