/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.Repository;
import org.revenj.patterns.SearchableRepository;

public interface PersistableRepository<T extends AggregateRoot>
extends Repository<T>,
SearchableRepository<T> {
    public String[] persist(Collection<T> var1, Collection<Map.Entry<T, T>> var2, Collection<T> var3) throws IOException;

    default public String[] insert(Collection<T> items) throws IOException {
        return this.persist(items, null, null);
    }

    default public String[] insert(T[] items) throws IOException {
        return this.insert((Collection<T>)Arrays.asList(items));
    }

    default public String insert(T item) throws IOException {
        return this.persist(Collections.singletonList(item), null, null)[0];
    }

    default public void update(Collection<T> items) throws IOException {
        ArrayList<Map.Entry<T, T>> pairs = new ArrayList<Map.Entry<T, T>>(items.size());
        for (AggregateRoot item : items) {
            pairs.add(new AbstractMap.SimpleEntry<Object, AggregateRoot>(null, item));
        }
        this.persist(null, pairs, null);
    }

    default public void update(T[] items) throws IOException {
        this.update((T)Arrays.asList(items));
    }

    default public void update(T old, T current) throws IOException {
        this.persist(null, Collections.singletonList(new AbstractMap.SimpleEntry<T, T>(old, current)), null);
    }

    default public void update(T item) throws IOException {
        this.update(null, item);
    }

    default public void delete(Collection<T> items) throws IOException {
        this.persist(null, null, items);
    }

    default public void delete(T[] items) throws IOException {
        this.delete((T)Arrays.asList(items));
    }

    default public void delete(T item) throws IOException {
        this.persist(null, null, Collections.singletonList(item));
    }
}

