/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.util.ArrayList;
import java.util.List;
import org.revenj.postgres.PostgresBuffer;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.PostgresTuple;

public abstract class BoolConverter {
    private static final char[] TRUE = "true".toCharArray();
    private static final char[] FALSE = "false".toCharArray();

    public static void serializeURI(PostgresBuffer sw, Boolean value) {
        if (value == null) {
            return;
        }
        if (value.booleanValue()) {
            sw.addToBuffer(TRUE);
        } else {
            sw.addToBuffer(FALSE);
        }
    }

    public static Boolean parseNullable(PostgresReader reader) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        reader.read();
        return cur == 116;
    }

    public static boolean parse(PostgresReader reader) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return false;
        }
        reader.read();
        return cur == 116;
    }

    public static List<Boolean> parseCollection(PostgresReader reader, int context, boolean allowNulls) {
        Boolean defaultValue;
        boolean espaced;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = espaced = cur != 123;
        if (espaced) {
            reader.read(context);
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        cur = reader.peek();
        if (cur == 125) {
            reader.read();
        }
        Boolean bl2 = defaultValue = allowNulls ? null : Boolean.valueOf(false);
        while (cur != -1 && cur != 125) {
            cur = reader.read();
            if (cur == 116) {
                list.add(true);
            } else if (cur == 102) {
                list.add(false);
            } else {
                reader.read(3);
                list.add(defaultValue);
            }
            cur = reader.read();
        }
        if (espaced) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(Boolean value) {
        if (value == null) {
            return null;
        }
        return new BoolTuple(value);
    }

    public static PostgresTuple toTuple(boolean value) {
        return new BoolTuple(value);
    }

    static class BoolTuple
    extends PostgresTuple {
        private final char value;

        public BoolTuple(boolean value) {
            this.value = (char)(value ? 116 : 102);
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(this.value);
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(this.value);
        }

        @Override
        public String buildTuple(boolean quote) {
            return quote ? "'" + this.value + "'" : Character.toString(this.value);
        }
    }
}

