/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.revenj.extensibility.Container;

final class SimpleContainer
implements Container {
    private static final ConcurrentMap<Class<?>, CtorInfo[]> classCache = new ConcurrentHashMap();
    private static final ConcurrentMap<Type, TypeInfo> typeCache = new ConcurrentHashMap<Type, TypeInfo>();
    private static final ConcurrentMap<String, Type> typeNameMappings = new ConcurrentHashMap<String, Type>();
    private final Map<Type, List<Registration<?>>> container = new HashMap();
    private final SimpleContainer parent;
    private final boolean resolveUnknown;
    private final CopyOnWriteArrayList<AutoCloseable> closeables = new CopyOnWriteArrayList();

    SimpleContainer(boolean resolveUnknown) {
        this.parent = null;
        this.resolveUnknown = resolveUnknown;
        this.registerGenerics(Optional.class, (locator, args) -> {
            try {
                return Optional.ofNullable(locator.resolve(args[0]));
            }
            catch (ReflectiveOperationException ignore) {
                return Optional.empty();
            }
        });
        this.registerGenerics(Callable.class, (locator, args) -> () -> locator.resolve(args[0]));
        this.registerFactory((Type)((Object)Container.class), Container::createScope, false);
    }

    private SimpleContainer(SimpleContainer parent) {
        this.parent = parent;
        this.resolveUnknown = parent.resolveUnknown;
    }

    private Either<Object> tryResolveClass(Class<?> manifest, SimpleContainer caller) {
        Throwable error = null;
        CtorInfo[] constructors = (CtorInfo[])classCache.get(manifest);
        if (constructors == null) {
            Constructor<?>[] ctors = manifest.getConstructors();
            constructors = new CtorInfo[ctors.length];
            for (int i = 0; i < ctors.length; ++i) {
                constructors[i] = new CtorInfo(ctors[i]);
            }
            classCache.putIfAbsent(manifest, constructors);
        }
        for (CtorInfo info : constructors) {
            Type[] genTypes = info.genTypes;
            Object[] args = new Object[genTypes.length];
            boolean success = true;
            for (int i = 0; i < genTypes.length; ++i) {
                Type p = genTypes[i];
                Either<Object> arg = this.tryResolve(p, caller);
                if (arg.hasError()) {
                    success = false;
                    if (error == null) {
                        error = arg.error;
                        break;
                    }
                    error.addSuppressed(arg.error);
                    break;
                }
                args[i] = arg.value;
            }
            if (!success) continue;
            try {
                Object instance = info.ctor.newInstance(args);
                return Either.success(instance);
            }
            catch (Exception e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        return error == null ? Either.fail("Unable to find constructors for: " + manifest) : Either.fail(error);
    }

    private Either<Object> tryResolveType(ParameterizedType type, SimpleContainer caller) {
        TypeInfo typeInfo = (TypeInfo)typeCache.get(type);
        if (typeInfo == null) {
            typeInfo = new TypeInfo(type);
            typeCache.putIfAbsent(type, typeInfo);
        }
        if (typeInfo.rawClass == null) {
            return Either.fail(type + " is not an instance of Class<?> and cannot be resolved");
        }
        Registration<?> registration = this.getRegistration(typeInfo.rawClass);
        if (registration != null && registration.biFactory != null && typeInfo.genericArguments != null) {
            try {
                Object result = registration.biFactory.apply(caller, typeInfo.genericArguments);
                return Either.success(result);
            }
            catch (Exception ex) {
                return Either.fail(ex);
            }
        }
        if (typeInfo.constructors.length == 0 && typeInfo.mappedType != null) {
            return this.tryResolve(typeInfo.mappedType, caller);
        }
        Map<Type, Type> mappings = typeInfo.mappings;
        return this.tryResolveTypeFrom(typeInfo, mappings, caller);
    }

    private Either<Object> tryResolveTypeFrom(TypeInfo typeInfo, Map<Type, Type> mappings, SimpleContainer caller) {
        Throwable error = null;
        for (CtorInfo info : typeInfo.constructors) {
            Type[] genTypes = info.genTypes;
            Object[] args = new Object[genTypes.length];
            boolean success = true;
            for (int i = 0; i < genTypes.length; ++i) {
                Either<Object> arg;
                Type p = genTypes[i];
                if (p instanceof ParameterizedType) {
                    ParameterizedType nestedType = (ParameterizedType)p;
                    TypeInfo nestedInfo = (TypeInfo)typeCache.get(nestedType);
                    if (nestedInfo == null) {
                        nestedInfo = new TypeInfo(nestedType);
                        typeCache.putIfAbsent(nestedType, nestedInfo);
                    }
                    if (nestedInfo.rawClass == null) {
                        success = false;
                        ReflectiveOperationException roe = new ReflectiveOperationException("Nested parametrized type: " + nestedType + " is not an instance of Class<?>. Error while resolving constructor: " + info.ctor);
                        if (error == null) {
                            error = roe;
                            break;
                        }
                        error.addSuppressed(roe);
                        break;
                    }
                    if (nestedInfo.rawClass == Optional.class) {
                        args[i] = this.tryResolve(nestedInfo.genericArguments[0], caller);
                        continue;
                    }
                    HashMap<Type, Type> nestedMappings = new HashMap<Type, Type>(typeInfo.mappings);
                    for (Map.Entry<Type, Type> entry : nestedInfo.mappings.entrySet()) {
                        Type parentValue = (Type)nestedMappings.get(entry.getValue());
                        nestedMappings.put(entry.getKey(), parentValue != null ? parentValue : entry.getValue());
                    }
                    Either<Object> arg2 = this.tryResolveTypeFrom(nestedInfo, nestedMappings, caller);
                    if (arg2.hasError()) {
                        success = false;
                        if (error == null) {
                            error = arg2.error;
                            break;
                        }
                        error.addSuppressed(arg2.error);
                        break;
                    }
                    args[i] = arg2.value;
                    continue;
                }
                while (p instanceof TypeVariable) {
                    if ((p = mappings.get(p)) != null) continue;
                    success = false;
                    break;
                }
                if ((arg = this.tryResolve(p, caller)).hasError()) {
                    success = false;
                    if (error == null) {
                        error = arg.error;
                        break;
                    }
                    error.addSuppressed(arg.error);
                    break;
                }
                args[i] = arg.value;
            }
            if (!success) continue;
            try {
                Object instance = info.ctor.newInstance(args);
                return Either.success(instance);
            }
            catch (Exception e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        return error == null ? Either.fail("Unable to find constructors for: " + typeInfo.rawClass) : Either.fail(error);
    }

    private Registration<?> getRegistration(Type type) {
        List<Registration<?>> registrations = this.container.get(type);
        if (registrations == null) {
            return this.parent != null ? this.parent.getRegistration(type) : null;
        }
        return registrations.get(registrations.size() - 1);
    }

    @Override
    public Object resolve(Type type) throws ReflectiveOperationException {
        Either<Object> found = this.tryResolve(type, this);
        if (found.hasError()) {
            if (found.error instanceof ReflectiveOperationException) {
                throw (ReflectiveOperationException)found.error;
            }
            throw new ReflectiveOperationException("Unable to resolve: " + type + ". Reason: " + found.error.getMessage(), found.error);
        }
        return found.value;
    }

    public Either<Object> tryResolve(Type type, SimpleContainer caller) {
        Registration<?> registration = this.getRegistration(type);
        if (registration == null) {
            Type basicType = (Type)typeNameMappings.get(type.toString());
            if (basicType != null && (registration = this.getRegistration(basicType)) != null) {
                this.resolveRegistration(registration, caller);
            }
            if (type instanceof ParameterizedType) {
                return this.tryResolveType((ParameterizedType)type, caller);
            }
            if (type instanceof GenericArrayType) {
                ParameterizedType pt;
                GenericArrayType gat = (GenericArrayType)type;
                if (gat.getGenericComponentType() instanceof Class) {
                    return this.tryResolveCollection((Class)gat.getGenericComponentType(), gat.getGenericComponentType(), caller);
                }
                if (gat.getGenericComponentType() instanceof ParameterizedType && (pt = (ParameterizedType)gat.getGenericComponentType()).getRawType() instanceof Class) {
                    return this.tryResolveCollection((Class)pt.getRawType(), pt, caller);
                }
            }
            if (!(type instanceof Class)) {
                return Either.fail(type + " is not an instance of Class<?> and cannot be resolved since it's not registered in the container.");
            }
            Class target = (Class)type;
            if (target.isArray()) {
                return this.tryResolveCollection(target.getComponentType(), target.getComponentType(), caller);
            }
            if (this.resolveUnknown) {
                if (target.isInterface()) {
                    return Either.fail(type + " is not an class and cannot be resolved since it's not registered in the container.\n" + "Try resolving implementation instead.");
                }
                return this.tryResolveClass(target, caller);
            }
            return target.isInterface() ? Either.fail(type + " is not registered in the container.\n" + "Since " + type + " is an interface, it must be registered into the container.") : Either.fail(type + " is not registered in the container.\n" + "If you wish to resolve types not registered in the container, specify revenj.resolveUnknown=true in Properties configuration.");
        }
        if (registration.biFactory != null && type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            TypeInfo typeInfo = (TypeInfo)typeCache.get(type);
            if (typeInfo == null) {
                typeInfo = new TypeInfo(pt);
                typeCache.putIfAbsent(type, typeInfo);
            }
            if (typeInfo.genericArguments != null) {
                try {
                    Object result = registration.biFactory.apply(caller, typeInfo.genericArguments);
                    return Either.success(result);
                }
                catch (Exception ex) {
                    return Either.fail(ex);
                }
            }
        }
        return this.resolveRegistration(registration, caller);
    }

    private Either<Object> tryResolveCollection(Class<?> container, Type element, SimpleContainer caller) {
        ArrayList registrations = new ArrayList();
        SimpleContainer current = caller;
        do {
            List<Registration<?>> found;
            if ((found = current.container.get(element)) == null) continue;
            registrations.addAll(0, found);
        } while ((current = current.parent) != null);
        if (registrations.isEmpty()) {
            return Either.success(Array.newInstance(container, 0));
        }
        ArrayList result = new ArrayList(registrations.size());
        for (int i = 0; i < registrations.size(); ++i) {
            Either<Object> item = this.resolveRegistration((Registration)registrations.get(i), caller);
            if (!item.isPresent()) continue;
            result.add(item.value);
        }
        Object[] instance = (Object[])Array.newInstance(container, result.size());
        for (int i = 0; i < instance.length; ++i) {
            instance[i] = result.get(i);
        }
        return Either.success(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<Object> resolveRegistration(Registration<?> registration, SimpleContainer caller) {
        if (registration.instance != null) {
            return Either.success(registration.instance);
        }
        if (registration.singleFactory != null) {
            try {
                Object instance;
                if (registration.singleton) {
                    SimpleContainer simpleContainer = this;
                    synchronized (simpleContainer) {
                        if (registration.promoted) {
                            return Either.success(registration.instance);
                        }
                        instance = registration.singleFactory.apply(this);
                        if (instance instanceof AutoCloseable) {
                            this.closeables.add((AutoCloseable)instance);
                        }
                        registration.promoteToSingleton(instance);
                    }
                } else {
                    instance = registration.singleFactory.apply(this);
                }
                return Either.success(instance);
            }
            catch (Throwable ex) {
                return Either.fail(ex);
            }
        }
        if (registration.singleton) {
            SimpleContainer simpleContainer = this;
            synchronized (simpleContainer) {
                if (registration.promoted) {
                    return Either.success(registration.instance);
                }
                Either<Object> tryInstance = this.tryResolveClass(registration.manifest, caller);
                if (tryInstance.isPresent()) {
                    if (tryInstance.value instanceof AutoCloseable) {
                        this.closeables.add((AutoCloseable)tryInstance.value);
                    }
                    registration.promoteToSingleton(tryInstance.value);
                }
                return tryInstance;
            }
        }
        return this.tryResolveClass(registration.manifest, caller);
    }

    private synchronized void addToRegistry(Type type, Registration registration) {
        List<Registration<?>> registrations = this.container.get(type);
        typeNameMappings.put(type.toString(), type);
        if (registrations == null) {
            registrations = new CopyOnWriteArrayList();
            registrations.add(registration);
            this.container.put(type, registrations);
        } else {
            registrations.add(registration);
        }
    }

    @Override
    public void registerClass(Type type, Class<?> manifest, boolean singleton) {
        this.addToRegistry(type, Registration.register(this, manifest, singleton));
    }

    @Override
    public void registerInstance(Type type, Object service, boolean handleClose) {
        if (handleClose && service instanceof AutoCloseable) {
            this.closeables.add((AutoCloseable)service);
        }
        this.addToRegistry(type, Registration.register(this, service));
    }

    @Override
    public void registerFactory(Type type, Function<Container, ?> factory, boolean singleton) {
        this.addToRegistry(type, Registration.register(this, factory, singleton));
    }

    @Override
    public <T> void registerGenerics(Class<T> container, BiFunction<Container, Type[], T> factory) {
        this.addToRegistry(container, Registration.register(this, factory, false));
    }

    @Override
    public Container createScope() {
        return new SimpleContainer(this);
    }

    @Override
    public void close() throws Exception {
        this.container.clear();
        for (AutoCloseable closable : this.closeables) {
            closable.close();
        }
        this.closeables.clear();
    }

    private static final class Either<T> {
        final T value;
        final Throwable error;

        private Either(T value, Throwable error) {
            this.value = value;
            this.error = error;
        }

        boolean hasError() {
            return this.error != null;
        }

        boolean isPresent() {
            return this.error == null;
        }

        static <T> Either<T> success(T value) {
            return new Either<T>(value, null);
        }

        static <T> Either<T> fail(Throwable error) {
            return new Either<Object>(null, error);
        }

        static <T> Either<T> fail(String error) {
            return new Either<Object>(null, new ReflectiveOperationException(error));
        }
    }

    private static class CtorInfo {
        final Constructor<?> ctor;
        final Type[] rawTypes;
        final Type[] genTypes;

        public CtorInfo(Constructor<?> ctor) {
            this.ctor = ctor;
            this.rawTypes = ctor.getParameterTypes();
            this.genTypes = ctor.getGenericParameterTypes();
        }
    }

    private static class TypeInfo {
        final CtorInfo[] constructors;
        final Class<?> rawClass;
        final Map<Type, Type> mappings = new HashMap<Type, Type>();
        final Type[] genericArguments;
        final Type mappedType;
        final String name;

        public TypeInfo(ParameterizedType type) {
            Type rawType = type.getRawType();
            if (rawType instanceof Class) {
                this.rawClass = (Class)rawType;
                this.genericArguments = type.getActualTypeArguments();
                TypeVariable<Class<?>>[] variables = this.rawClass.getTypeParameters();
                for (int i = 0; i < this.genericArguments.length; ++i) {
                    this.mappings.put(variables[i], this.genericArguments[i]);
                }
                Constructor<?>[] ctors = this.rawClass.getConstructors();
                this.constructors = new CtorInfo[ctors.length];
                for (int i = 0; i < ctors.length; ++i) {
                    this.constructors[i] = new CtorInfo(ctors[i]);
                }
            } else {
                this.constructors = null;
                this.rawClass = null;
                this.genericArguments = null;
            }
            this.name = type.toString();
            this.mappedType = (Type)typeNameMappings.get(this.name);
        }
    }

    private static class Registration<T> {
        public final SimpleContainer owner;
        public final Class<T> manifest;
        public T instance;
        public final Function<Container, T> singleFactory;
        public final BiFunction<Container, Type[], T> biFactory;
        public final boolean singleton;
        boolean promoted;

        private Registration(SimpleContainer owner, Class<T> manifest, T instance, Function<Container, T> singleFactory, BiFunction<Container, Type[], T> biFactory, boolean singleton) {
            this.owner = owner;
            this.manifest = manifest;
            this.instance = instance;
            this.singleFactory = singleFactory;
            this.biFactory = biFactory;
            this.singleton = singleton;
        }

        static <T> Registration<T> register(SimpleContainer owner, Class<T> manifest, boolean singleton) {
            return new Registration<Object>(owner, manifest, null, null, null, singleton);
        }

        static <T> Registration<T> register(SimpleContainer owner, T instance) {
            return new Registration<T>(owner, null, instance, null, null, true);
        }

        static <T> Registration<T> register(SimpleContainer owner, Function<Container, T> factory, boolean singleton) {
            return new Registration<Object>(owner, null, null, factory, null, singleton);
        }

        static <T> Registration<T> register(SimpleContainer owner, BiFunction<Container, Type[], T> factory, boolean singleton) {
            return new Registration<Object>(owner, null, null, null, factory, singleton);
        }

        void promoteToSingleton(Object instance) {
            this.promoted = true;
            this.instance = instance;
        }
    }
}

