/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.json;

import com.dslplatform.json.Configuration;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.ServiceLoader;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.Serialization;

public class DslJsonSerialization
extends DslJson<ServiceLocator>
implements Serialization<String> {
    public DslJsonSerialization(ServiceLocator locator, Optional<DslJson.Fallback<ServiceLocator>> fallback) {
        super((Object)locator, false, true, false, (DslJson.Fallback)fallback.orElse(null), ServiceLoader.load(Configuration.class));
    }

    @Override
    public String serialize(Object value) throws IOException {
        if (value == null) {
            return "null";
        }
        JsonWriter jw = new JsonWriter();
        Class<?> manifest = value.getClass();
        if (!this.serialize(jw, manifest, value)) {
            if (this.fallback != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.fallback.serialize(value, (OutputStream)os);
                return os.toString("UTF-8");
            }
            throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
        }
        return jw.toString();
    }

    @Override
    public Object deserialize(Type type, String data) throws IOException {
        byte[] bytes = data.getBytes("UTF-8");
        return super.deserialize(type, bytes, bytes.length);
    }
}

