/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DataChangeNotification;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.History;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.ObjectHistory;
import org.revenj.patterns.Query;
import org.revenj.patterns.Report;
import org.revenj.patterns.Specification;
import rx.Observable;

public interface DataContext {
    public <T extends Identifiable> List<T> find(Class<T> var1, Collection<String> var2);

    default public <T extends Identifiable> Optional<T> find(Class<T> manifest, String uri) {
        List<T> found = this.find(manifest, Collections.singletonList(uri));
        return found.size() == 1 ? Optional.of(found.get(0)) : Optional.empty();
    }

    default public <T extends Identifiable> List<T> find(Class<T> manifest, String[] uris) {
        return this.find(manifest, Arrays.asList(uris));
    }

    public <T extends DataSource> Query<T> query(Class<T> var1, Specification<T> var2);

    default public <T extends DataSource> Query<T> query(Class<T> manifest) {
        return this.query(manifest, null);
    }

    public <T extends DataSource> List<T> search(Class<T> var1, Specification<T> var2, Integer var3, Integer var4);

    default public <T extends DataSource> List<T> search(Class<T> manifest) {
        return this.search(manifest, null, null, null);
    }

    default public <T extends DataSource> List<T> search(Class<T> manifest, Specification<T> filter) {
        return this.search(manifest, filter, null, null);
    }

    default public <T extends DataSource> List<T> search(Class<T> manifest, Specification<T> filter, int limit) {
        return this.search(manifest, filter, limit, null);
    }

    public <T extends DataSource> long count(Class<T> var1, Specification<T> var2);

    default public <T extends DataSource> long count(Class<T> manifest) {
        return this.count(manifest, null);
    }

    public <T extends DataSource> boolean exists(Class<T> var1, Specification<T> var2);

    default public <T extends DataSource> boolean exists(Class<T> manifest) {
        return this.exists(manifest, null);
    }

    public <T extends AggregateRoot> void create(Collection<T> var1) throws IOException;

    default public <T extends AggregateRoot> void create(T aggregate) throws IOException {
        this.create((T)((Object)Collections.singletonList(aggregate)));
    }

    public <T extends AggregateRoot> void update(Collection<Map.Entry<T, T>> var1) throws IOException;

    default public <T extends AggregateRoot> void update(T oldAggregate, T newAggregate) throws IOException {
        this.update((T)((Object)Collections.singletonList(new AbstractMap.SimpleEntry<T, T>(oldAggregate, newAggregate))));
    }

    default public <T extends AggregateRoot> void update(T aggregate) throws IOException {
        this.update((T)((Object)Collections.singletonList(new AbstractMap.SimpleEntry<Object, T>(null, aggregate))));
    }

    default public <T extends AggregateRoot> void update(List<T> aggregates) throws IOException {
        ArrayList<AbstractMap.SimpleEntry<Object, AggregateRoot>> collection = new ArrayList<AbstractMap.SimpleEntry<Object, AggregateRoot>>(aggregates.size());
        for (AggregateRoot item : aggregates) {
            collection.add(new AbstractMap.SimpleEntry<Object, AggregateRoot>(null, item));
        }
        this.update((T)((Object)collection));
    }

    public <T extends AggregateRoot> void delete(Collection<T> var1) throws IOException;

    default public <T extends AggregateRoot> void delete(T aggregate) throws IOException {
        this.delete((T)((Object)Collections.singletonList(aggregate)));
    }

    public <T extends DomainEvent> void submit(Collection<T> var1);

    default public <T extends DomainEvent> void submit(T event) {
        this.submit((T)((Object)Collections.singletonList(event)));
    }

    public <T> T populate(Report<T> var1);

    public <T extends Identifiable> Observable<DataChangeNotification.TrackInfo<T>> track(Class<T> var1);

    public <T extends ObjectHistory> List<History<T>> history(Class<T> var1, Collection<String> var2);

    default public <T extends ObjectHistory> Optional<History<T>> history(Class<T> manifest, String uri) {
        List<History<T>> found = this.history(manifest, Collections.singletonList(uri));
        return found.size() == 1 ? Optional.of(found.get(0)) : Optional.empty();
    }

    default public <T extends ObjectHistory> List<History<T>> history(Class<T> manifest, String[] uris) {
        return this.history(manifest, Arrays.asList(uris));
    }
}

