/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.converters;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.util.PGobject;
import org.revenj.postgres.PostgresBuffer;
import org.revenj.postgres.PostgresReader;
import org.revenj.postgres.PostgresWriter;
import org.revenj.postgres.converters.NumberConverter;
import org.revenj.postgres.converters.PostgresTuple;

public abstract class DateConverter {
    public static final LocalDate MIN_DATE = LocalDate.of(1, 1, 1);

    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, LocalDate value) throws SQLException {
        PGobject pg = new PGobject();
        pg.setType("date");
        char[] buf = sw.getTempBuffer();
        DateConverter.serialize(buf, 0, value);
        pg.setValue(new String(buf, 0, 10));
        ps.setObject(index, pg);
    }

    public static void serializeURI(PostgresBuffer sw, LocalDate value) {
        DateConverter.serialize(sw.getTempBuffer(), 0, value);
        sw.addToBuffer(sw.getTempBuffer(), 10);
    }

    private static void serialize(char[] buf, int start, LocalDate value) {
        NumberConverter.write4(value.getYear(), buf, start);
        buf[start + 4] = 45;
        NumberConverter.write2(value.getMonthValue(), buf, start + 5);
        buf[start + 7] = 45;
        NumberConverter.write2(value.getDayOfMonth(), buf, start + 8);
    }

    public static LocalDate parse(PostgresReader reader, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : MIN_DATE;
        }
        LocalDate res = DateConverter.parseDate(reader, cur);
        reader.read();
        return res;
    }

    private static LocalDate parseDate(PostgresReader reader, int cur) throws IOException {
        if (cur == 92 || cur == 34) {
            throw new RuntimeException("Negative dates are not yet implemented.");
        }
        char[] buf = reader.tmp;
        buf[0] = (char)cur;
        reader.fillTotal(buf, 1, 9);
        if (buf[4] != '-') {
            return DateConverter.parseDateSlow(buf, reader);
        }
        return LocalDate.of(NumberConverter.read4(buf, 0), NumberConverter.read2(buf, 5), NumberConverter.read2(buf, 8));
    }

    private static LocalDate parseDateSlow(char[] buf, PostgresReader reader) {
        int i;
        int foundAt;
        for (foundAt = 4; foundAt < buf.length && buf[foundAt] != '-'; ++foundAt) {
        }
        if (foundAt == buf.length) {
            throw new RuntimeException("Invalid date value.");
        }
        int year = NumberConverter.parsePositive(buf, 0, foundAt);
        char[] newBuf = reader.tmp;
        for (i = foundAt + 1; i < buf.length; ++i) {
            newBuf[i - foundAt - 1] = buf[i];
        }
        for (i = buf.length - foundAt - 1; i < 5; ++i) {
            newBuf[i] = (char)reader.read();
        }
        return LocalDate.of(year, NumberConverter.read2(newBuf, 0), NumberConverter.read2(newBuf, 3));
    }

    public static List<LocalDate> parseCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        LocalDate defaultValue;
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur == 34 || cur == 92;
        if (escaped) {
            reader.read(context);
        }
        ArrayList<LocalDate> list = new ArrayList<LocalDate>();
        cur = reader.peek();
        if (cur == 125) {
            reader.read();
        }
        LocalDate localDate = defaultValue = allowNulls ? null : MIN_DATE;
        while (cur != -1 && cur != 125) {
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                list.add(defaultValue);
                continue;
            }
            list.add(DateConverter.parseDate(reader, cur));
            cur = reader.read();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(LocalDate value) {
        if (value == null) {
            return null;
        }
        return new DateTuple(value);
    }

    static class DateTuple
    extends PostgresTuple {
        private final LocalDate value;

        public DateTuple(LocalDate value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            DateConverter.serialize(sw.tmp, 0, this.value);
            sw.writeBuffer(10);
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            this.insertRecord(sw, escaping, mappings);
        }

        @Override
        public String buildTuple(boolean quote) {
            if (quote) {
                char[] buf = new char[12];
                buf[0] = 39;
                DateConverter.serialize(buf, 1, this.value);
                buf[11] = 39;
                return new String(buf, 0, 12);
            }
            char[] buf = new char[10];
            DateConverter.serialize(buf, 0, this.value);
            return new String(buf, 0, 10);
        }
    }
}

