/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.postgres.jinq.jpqlquery;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.revenj.postgres.jinq.jpqlquery.From;
import org.revenj.postgres.jinq.jpqlquery.GeneratedQueryParameter;

class QueryGenerationState {
    private final StringBuilder queryString = new StringBuilder();
    final Map<From, String> fromAliases = new IdentityHashMap<From, String>();
    final List<GeneratedQueryParameter> parameters = new ArrayList<GeneratedQueryParameter>();
    int nextParam = 0;
    int nextCol = 1;
    int nextTable = 0;
    static final String TableLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    QueryGenerationState() {
    }

    final String buildQueryString() {
        return this.queryString.toString();
    }

    public String generateFromAlias(From from) {
        if (this.fromAliases.containsKey(from)) {
            return this.fromAliases.get(from);
        }
        String alias = this.nextTableAlias();
        this.fromAliases.put(from, alias);
        return alias;
    }

    public String getFromAlias(From from) {
        return this.fromAliases.get(from);
    }

    public String registerParameter(Object paramNode, int lambdaIndex, int argIndex, String argType) {
        String paramName = this.nextParamIndex();
        this.parameters.add(new GeneratedQueryParameter(paramName, lambdaIndex, argIndex, argType));
        return paramName;
    }

    public String registerParameter(Object paramNode, int lambdaIndex, String fieldName, String argType) {
        String paramName = this.nextParamIndex();
        this.parameters.add(new GeneratedQueryParameter(paramName, lambdaIndex, fieldName, argType));
        return paramName;
    }

    public QueryGenerationState appendQuery(String str) {
        this.queryString.append(str);
        return this;
    }

    private String nextTableAlias() {
        int toReturn = this.nextTable++;
        return QueryGenerationState.intToTablePrefix(toReturn);
    }

    private String nextColAlias() {
        int toReturn = this.nextCol++;
        return "COL" + toReturn;
    }

    private String nextParamIndex() {
        int toReturn = this.nextParam++;
        return "param" + toReturn;
    }

    static int tablePrefixToInt(String prefix) {
        int num = 0;
        int multiplier = 1;
        for (int n = prefix.length() - 1; n >= 0; --n) {
            int offset = TableLetters.indexOf(prefix.substring(n, n + 1));
            assert (offset != -1);
            num = n == prefix.length() - 1 ? (num += offset * multiplier) : (num += (offset + 1) * multiplier);
            multiplier *= TableLetters.length();
        }
        return num;
    }

    static String intToTablePrefix(int num) {
        String prefix = "";
        ++num;
        while (num > 0) {
            int offset = (num - 1) % TableLetters.length();
            prefix = TableLetters.substring(offset, offset + 1) + prefix;
            num = (num - 1) / TableLetters.length();
        }
        return prefix;
    }
}

