/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"org.revenj.patterns.EventHandler"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RevenjProcessor
extends AbstractProcessor {
    private TypeElement eventTypeElement;
    private DeclaredType eventDeclaredType;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.eventTypeElement = processingEnv.getElementUtils().getTypeElement("org.revenj.patterns.EventHandler");
        this.eventDeclaredType = processingEnv.getTypeUtils().getDeclaredType(this.eventTypeElement, new TypeMirror[0]);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> eventAnnotated = roundEnv.getElementsAnnotatedWith(this.eventTypeElement);
        if (!eventAnnotated.isEmpty()) {
            HashMap handlers = new HashMap();
            for (Element element : eventAnnotated) {
                if (!(element instanceof TypeElement)) continue;
                TypeElement element2 = (TypeElement)element;
                if (!this.hasPublicCtor(element2)) {
                    AnnotationMirror eventAnnotation = this.getAnnotation(element2, this.eventDeclaredType);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "EventHandler requires public constructor", element2, eventAnnotation);
                    continue;
                }
                boolean foundImpl = false;
                for (TypeMirror typeMirror : element2.getInterfaces()) {
                    String sign = typeMirror.toString();
                    if (!sign.startsWith("org.revenj.patterns.DomainEventHandler<")) continue;
                    ArrayList<String> impl = (ArrayList<String>)handlers.get(sign);
                    if (impl == null) {
                        impl = new ArrayList<String>();
                        handlers.put(sign, impl);
                    }
                    if (element2.getNestingKind().isNested()) {
                        impl.add(element2.getEnclosingElement().asType().toString() + "$" + element2.getSimpleName().toString());
                    } else {
                        impl.add(element2.asType().toString());
                    }
                    foundImpl = true;
                }
                if (foundImpl) continue;
                AnnotationMirror eventAnnotation = this.getAnnotation(element2, this.eventDeclaredType);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "EventHandler annotation on " + element2.toString() + " requires implementation of DomainEventHandler<T extends DomainEvent>", element2, eventAnnotation);
            }
            if (!handlers.isEmpty()) {
                try {
                    for (Map.Entry entry : handlers.entrySet()) {
                        FileObject rfo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + URLEncoder.encode((String)entry.getKey(), "UTF-8"), new Element[0]);
                        BufferedWriter bw = new BufferedWriter(rfo.openWriter());
                        for (String string : (List)entry.getValue()) {
                            bw.write(string);
                            bw.newLine();
                        }
                        bw.close();
                    }
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving event handler registrations");
                }
            }
        }
        return false;
    }

    private boolean hasPublicCtor(Element element) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return true;
        }
        return false;
    }

    private boolean checkInterfaces(TypeElement element, TypeElement target) {
        for (TypeElement type : ElementFilter.typesIn(element.getEnclosedElements())) {
            String string = type.getSimpleName().toString();
        }
        return true;
    }

    private AnnotationMirror getAnnotation(Element element, DeclaredType annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }
}

