/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.revenj.extensibility.Container;
import org.revenj.patterns.DataChangeNotification;
import rx.Observable;
import rx.Subscription;
import rx.subjects.PublishSubject;

final class ChangeNotification<T>
implements Closeable {
    private final Subscription subscription;
    private final Observable<T> eagerChanges;
    private final Observable<Callable<T>> lazyChanges;
    private final Observable<Callable<List<T>>> bulkChanges;

    private ChangeNotification(Class<T> manifest, DataChangeNotification notifications) {
        PublishSubject subject = PublishSubject.create();
        this.subscription = notifications.track(manifest).subscribe(arg_0 -> ((PublishSubject)subject).onNext(arg_0));
        Observable source = subject.asObservable();
        this.bulkChanges = source.map(it -> it.result);
        this.lazyChanges = source.flatMapIterable(it -> {
            try {
                ArrayList<Callable<Object>> callables = new ArrayList<Callable<Object>>(it.uris.length);
                int i = 0;
                while (i < it.uris.length) {
                    int ind = i++;
                    callables.add(() -> it.result.call().get(ind));
                }
                return callables;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.eagerChanges = source.flatMapIterable(it -> {
            try {
                return it.result.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void registerContainer(Container container, DataChangeNotification notification) {
        container.registerGenerics(Observable.class, (locator, arguments) -> {
            if (((Type[])arguments).length == 1) {
                Type[] genericArguments;
                Type arg = arguments[0];
                if (arg instanceof Class) {
                    ChangeNotification cn = new ChangeNotification((Class)arg, notification);
                    return cn.eagerChanges;
                }
                if (arg instanceof ParameterizedType && ((ParameterizedType)arg).getRawType() == Callable.class && (genericArguments = ((ParameterizedType)arg).getActualTypeArguments()).length == 1) {
                    ParameterizedType npt;
                    Type first = genericArguments[0];
                    if (first instanceof Class) {
                        ChangeNotification cn = new ChangeNotification((Class)first, notification);
                        return cn.lazyChanges;
                    }
                    if (first instanceof ParameterizedType && (npt = (ParameterizedType)first).getActualTypeArguments().length == 1 && npt.getRawType() instanceof Class && npt.getActualTypeArguments()[0] instanceof Class && Collection.class.isAssignableFrom((Class)npt.getRawType())) {
                        ChangeNotification cn = new ChangeNotification((Class)npt.getActualTypeArguments()[0], notification);
                        return cn.bulkChanges;
                    }
                }
            }
            throw new RuntimeException("Invalid arguments for Observable<T>. Supported arguments: Observable<Callable<List<T>>>, Observable<T> and Observable<Callable<T>>");
        });
    }

    @Override
    public void close() {
        this.subscription.unsubscribe();
    }
}

