/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.revenj.GlobalEventStore;
import org.revenj.Utils;
import org.revenj.extensibility.Container;
import org.revenj.patterns.AggregateRoot;
import org.revenj.patterns.DataChangeNotification;
import org.revenj.patterns.DataContext;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.DomainEventStore;
import org.revenj.patterns.History;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.ObjectHistory;
import org.revenj.patterns.PersistableRepository;
import org.revenj.patterns.Query;
import org.revenj.patterns.Report;
import org.revenj.patterns.Repository;
import org.revenj.patterns.SearchableRepository;
import org.revenj.patterns.Specification;
import org.revenj.patterns.UnitOfWork;
import rx.Observable;

final class LocatorDataContext
implements UnitOfWork {
    private final Container locator;
    private ConcurrentHashMap<Class<?>, SearchableRepository> searchRepositories;
    private ConcurrentHashMap<Class<?>, Repository> lookupRepositories;
    private ConcurrentHashMap<Class<?>, PersistableRepository> persistableRepositories;
    private ConcurrentHashMap<Class<?>, Repository> historyRepositories;
    private ConcurrentHashMap<Class<?>, DomainEventStore> eventStores;
    private GlobalEventStore globalEventStore;
    private DataChangeNotification changes;
    private final Connection connection;
    private boolean hasChanges;
    private boolean closed;

    LocatorDataContext(Container locator, Connection connection) {
        this.locator = locator;
        this.connection = connection;
    }

    static DataContext asDataContext(Container container) {
        return new LocatorDataContext(container, null);
    }

    static UnitOfWork asUnitOfWork(Container container) {
        javax.sql.DataSource dataSource = container.resolve(javax.sql.DataSource.class);
        Container locator = container.createScope();
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                connection = dataSource.getConnection();
                connection.setAutoCommit(false);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        locator.registerInstance((Type)((Object)Connection.class), connection, false);
        return new LocatorDataContext(locator, connection);
    }

    private <T extends DataSource> SearchableRepository<T> getSearchableRepository(Class<T> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.searchRepositories == null) {
            this.searchRepositories = new ConcurrentHashMap();
        }
        return this.searchRepositories.computeIfAbsent(manifest, clazz -> {
            PersistableRepository repository;
            if (this.persistableRepositories != null && (repository = this.persistableRepositories.get(manifest)) != null) {
                return repository;
            }
            try {
                return (SearchableRepository)this.locator.resolve(Utils.makeGenericType(SearchableRepository.class, manifest, new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Repository is not registered for: " + manifest, ex);
            }
        });
    }

    private Repository getLookupRepository(Class<?> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.lookupRepositories == null) {
            this.lookupRepositories = new ConcurrentHashMap();
        }
        return this.lookupRepositories.computeIfAbsent(manifest, clazz -> {
            PersistableRepository repository;
            if (this.persistableRepositories != null && (repository = this.persistableRepositories.get(manifest)) != null) {
                return repository;
            }
            try {
                return (Repository)this.locator.resolve(Utils.makeGenericType(Repository.class, manifest, new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Repository is not registered for: " + manifest, ex);
            }
        });
    }

    private Repository getHistoryRepository(Class<?> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.historyRepositories == null) {
            this.historyRepositories = new ConcurrentHashMap();
        }
        return this.historyRepositories.computeIfAbsent(manifest, clazz -> {
            try {
                return (Repository)this.locator.resolve(Utils.makeGenericType(Repository.class, Utils.makeGenericType(History.class, manifest, new Type[0]), new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Repository is not registered for: " + manifest, ex);
            }
        });
    }

    private PersistableRepository getPersistableRepository(Class<?> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.persistableRepositories == null) {
            this.persistableRepositories = new ConcurrentHashMap();
        }
        return this.persistableRepositories.computeIfAbsent(manifest, clazz -> {
            try {
                return (PersistableRepository)this.locator.resolve(Utils.makeGenericType(PersistableRepository.class, manifest, new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Repository is not registered for: " + manifest, ex);
            }
        });
    }

    private DomainEventStore getEventStore(Class<?> manifest) {
        if (this.closed) {
            throw new RuntimeException("Unit of work has been closed");
        }
        if (this.eventStores == null) {
            this.eventStores = new ConcurrentHashMap();
        }
        return this.eventStores.computeIfAbsent(manifest, clazz -> {
            try {
                return (DomainEventStore)this.locator.resolve(Utils.makeGenericType(SearchableRepository.class, manifest, new Type[0]));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Domain event store is not registered for: " + manifest, ex);
            }
        });
    }

    @Override
    public <T extends Identifiable> Optional<T> find(Class<T> manifest, String uri) {
        return this.getLookupRepository(manifest).find(uri);
    }

    @Override
    public <T extends Identifiable> List<T> find(Class<T> manifest, Collection<String> uris) {
        return this.getLookupRepository(manifest).find(uris);
    }

    @Override
    public <T extends DataSource> Query<T> query(Class<T> manifest, Specification<T> filter) {
        return this.getSearchableRepository(manifest).query(filter);
    }

    @Override
    public <T extends DataSource> List<T> search(Class<T> manifest, Specification<T> filter, Integer limit, Integer offset) {
        return this.getSearchableRepository(manifest).search(filter, limit, offset);
    }

    @Override
    public <T extends DataSource> long count(Class<T> manifest, Specification<T> filter) {
        return this.getSearchableRepository(manifest).count(filter);
    }

    @Override
    public <T extends DataSource> boolean exists(Class<T> manifest, Specification<T> filter) {
        return this.getSearchableRepository(manifest).exists(filter);
    }

    @Override
    public <T extends AggregateRoot> void create(Collection<T> aggregates) throws IOException {
        if (aggregates.size() == 0) {
            return;
        }
        Class<?> manifest = ((AggregateRoot)aggregates.iterator().next()).getClass();
        this.getPersistableRepository(manifest).insert(aggregates);
        this.hasChanges = true;
    }

    @Override
    public <T extends AggregateRoot> void updatePairs(Collection<Map.Entry<T, T>> pairs) throws IOException {
        if (pairs.size() == 0) {
            return;
        }
        Class<?> manifest = ((AggregateRoot)pairs.iterator().next().getValue()).getClass();
        this.getPersistableRepository(manifest).persist(null, pairs, null);
        this.hasChanges = true;
    }

    @Override
    public <T extends AggregateRoot> void delete(Collection<T> aggregates) throws IOException {
        if (aggregates.size() == 0) {
            return;
        }
        Class<?> manifest = ((AggregateRoot)aggregates.iterator().next()).getClass();
        this.getPersistableRepository(manifest).delete(aggregates);
        this.hasChanges = true;
    }

    @Override
    public <T extends DomainEvent> void submit(Collection<T> events) {
        if (events.size() == 0) {
            return;
        }
        Class<?> manifest = ((DomainEvent)events.iterator().next()).getClass();
        this.getEventStore(manifest).submit(events);
        this.hasChanges = true;
    }

    @Override
    public <T extends DomainEvent> void queue(Collection<T> events) {
        if (this.globalEventStore == null) {
            this.globalEventStore = this.locator.resolve(GlobalEventStore.class);
        }
        for (DomainEvent e : events) {
            this.globalEventStore.queue(e);
        }
    }

    @Override
    public <T> T populate(Report<T> report) {
        return report.populate(this.locator);
    }

    @Override
    public <T extends ObjectHistory> List<History<T>> history(Class<T> manifest, Collection<String> uris) {
        return this.getHistoryRepository(manifest).find(uris);
    }

    @Override
    public <T extends Identifiable> Observable<DataChangeNotification.TrackInfo<T>> track(Class<T> manifest) {
        if (this.changes == null) {
            this.changes = this.locator.resolve(DataChangeNotification.class);
        }
        return this.changes.track(manifest);
    }

    @Override
    public void commit() {
        if (this.hasChanges) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        this.hasChanges = false;
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.hasChanges = false;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.connection != null) {
            if (this.hasChanges) {
                this.rollback();
            }
            try {
                this.connection.setAutoCommit(true);
                this.connection.close();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        try {
            this.locator.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.closed = true;
    }
}

