/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.postgresql.ds.PGPoolingDataSource;
import org.revenj.ChangeNotification;
import org.revenj.GlobalEventStore;
import org.revenj.LocatorDataContext;
import org.revenj.PostgresBulkReader;
import org.revenj.PostgresDatabaseNotification;
import org.revenj.RevenjPermissionManager;
import org.revenj.RevenjSystemState;
import org.revenj.ServicesPluginLoader;
import org.revenj.SimpleContainer;
import org.revenj.Utils;
import org.revenj.database.postgres.jinq.JinqMetaModel;
import org.revenj.extensibility.Container;
import org.revenj.extensibility.PluginLoader;
import org.revenj.extensibility.SystemAspect;
import org.revenj.extensibility.SystemState;
import org.revenj.patterns.DataChangeNotification;
import org.revenj.patterns.DataContext;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.DomainEventHandler;
import org.revenj.patterns.DomainModel;
import org.revenj.patterns.EagerNotification;
import org.revenj.patterns.Generic;
import org.revenj.patterns.RepositoryBulkReader;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.UnitOfWork;
import org.revenj.security.PermissionManager;
import org.revenj.serialization.Serialization;
import org.revenj.serialization.json.DslJsonSerialization;
import org.revenj.serialization.xml.XmlJaxbSerialization;
import org.w3c.dom.Element;

public abstract class Revenj {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Container setup() throws IOException {
        Properties properties = new Properties();
        File revProps = new File("revenj.properties");
        if (revProps.exists() && revProps.isFile()) {
            properties.load(new FileReader(revProps));
            return Revenj.setup(properties);
        } else {
            String location = System.getProperty("revenj.properties");
            if (location == null) throw new IOException("Unable to find revenj.properties. Searching in: " + revProps.getAbsolutePath());
            revProps = new File(location);
            if (!revProps.exists() || !revProps.isFile()) throw new IOException("Unable to find revenj.properties in alternative location. Searching in: " + revProps.getAbsolutePath());
            properties.load(new FileReader(revProps));
        }
        return Revenj.setup(properties);
    }

    public static Container setup(Properties properties) throws IOException {
        String plugins = properties.getProperty("revenj.pluginsPath");
        File pluginsPath = null;
        if (plugins != null) {
            File pp = new File(plugins);
            pluginsPath = pp.isDirectory() ? pp : null;
        }
        return Revenj.setup(Revenj.dataSource(properties), properties, Optional.ofNullable(pluginsPath), Optional.ofNullable(Thread.currentThread().getContextClassLoader()));
    }

    public static DataSource dataSource(Properties properties) throws IOException {
        String jdbcUrl = properties.getProperty("revenj.jdbcUrl");
        if (jdbcUrl == null) {
            throw new IOException("revenj.jdbcUrl is missing from Properties");
        }
        if (!jdbcUrl.startsWith("jdbc:postgresql:")) {
            throw new IOException("Invalid revenj.jdbcUrl provided. Expecting: 'jdbc:postgresql:...'. Found: '" + jdbcUrl + "'.\nIf you wish to use custom jdbc driver provide custom data source instead of using Postgres builtin data source.");
        }
        PGPoolingDataSource dataSource = new PGPoolingDataSource();
        dataSource.setUrl(jdbcUrl);
        String user = properties.getProperty("user");
        String revUser = properties.getProperty("revenj.user");
        if (revUser != null && revUser.length() > 0) {
            dataSource.setUser(revUser);
        } else if (user != null && user.length() > 0) {
            dataSource.setUser(user);
        }
        String password = properties.getProperty("password");
        String revPassword = properties.getProperty("revenj.password");
        if (revPassword != null && revPassword.length() > 0) {
            dataSource.setPassword(revPassword);
        } else if (password != null && password.length() > 0) {
            dataSource.setPassword(password);
        }
        return dataSource;
    }

    public static Container setup(DataSource dataSource, Properties properties, Optional<File> pluginsPath, Optional<ClassLoader> classLoader) throws IOException {
        ClassLoader loader;
        if (pluginsPath.isPresent()) {
            File[] jars = pluginsPath.get().listFiles(f -> f.getPath().toLowerCase().endsWith(".jar"));
            ArrayList<URL> urls = new ArrayList<URL>(jars.length);
            for (File j : jars) {
                try {
                    urls.add(j.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    throw new IOException(ex);
                }
            }
            loader = classLoader.isPresent() ? new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader.get()) : new URLClassLoader(urls.toArray(new URL[urls.size()]));
        } else {
            loader = classLoader.isPresent() ? classLoader.get() : Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<SystemAspect> aspects = ServiceLoader.load(SystemAspect.class, loader);
        return Revenj.setup(dataSource, properties, Optional.of(loader), aspects.iterator());
    }

    public static Container container(boolean resolveUnknown, ClassLoader loader) {
        SimpleContainer container = new SimpleContainer(resolveUnknown);
        for (SystemAspect aspect : ServiceLoader.load(SystemAspect.class, loader)) {
            try {
                aspect.configure(container);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return container;
    }

    public static Container setup(DataSource dataSource, Properties properties, Optional<ClassLoader> classLoader, Iterator<SystemAspect> aspects) throws IOException {
        RevenjSystemState state = new RevenjSystemState();
        ClassLoader loader = classLoader.orElse(Thread.currentThread().getContextClassLoader());
        SimpleContainer container = new SimpleContainer("true".equals(properties.getProperty("revenj.resolveUnknown")));
        container.registerAs(state, SystemState.class);
        container.registerInstance(properties);
        container.registerInstance((Type)((Object)ServiceLocator.class), container, false);
        container.registerInstance((Type)((Object)DataSource.class), dataSource, false);
        container.registerInstance((Type)((Object)ClassLoader.class), loader, false);
        container.register(GlobalEventStore.class, true);
        SimpleDomainModel domainModel = new SimpleDomainModel(loader);
        container.registerInstance((Type)((Object)DomainModel.class), domainModel, false);
        container.registerFactory((Type)((Object)DataContext.class), LocatorDataContext::asDataContext, false);
        container.registerFactory((Type)((Object)UnitOfWork.class), LocatorDataContext::asUnitOfWork, false);
        ServicesPluginLoader plugins = new ServicesPluginLoader(loader);
        container.registerInstance((Type)((Object)PluginLoader.class), plugins, false);
        PostgresDatabaseNotification databaseNotification = new PostgresDatabaseNotification(dataSource, Optional.of(domainModel), properties, state, container);
        container.registerInstance((Type)((Object)EagerNotification.class), databaseNotification, false);
        container.registerInstance((Type)((Object)DataChangeNotification.class), databaseNotification, true);
        ChangeNotification.registerContainer(container, databaseNotification);
        container.registerFactory((Type)((Object)RepositoryBulkReader.class), PostgresBulkReader::create, false);
        container.registerInstance((Type)((Object)PermissionManager.class), new RevenjPermissionManager(container), false);
        container.registerClass(new Generic<Serialization<String>>(){}.type, DslJsonSerialization.class, false);
        XmlJaxbSerialization xml = new XmlJaxbSerialization(container, Optional.of(plugins));
        container.registerInstance(new Generic<Serialization<Element>>(){}.type, xml, false);
        container.registerInstance(xml);
        int total = 0;
        if (aspects != null) {
            JinqMetaModel.configure(container);
            while (aspects.hasNext()) {
                aspects.next().configure(container);
                ++total;
            }
        }
        domainModel.setNamespace(properties.getProperty("revenj.namespace"));
        properties.setProperty("revenj.aspectsCount", Integer.toString(total));
        state.started(container);
        return container;
    }

    public static <T extends DomainEvent> void registerEvents(Container container, PluginLoader plugins, Class<T> manifest, Class<T[]> arrayManifest) throws Exception {
        ParameterizedType gt = Utils.makeGenericType(DomainEventHandler.class, manifest, new Type[0]);
        List<Class<DomainEventHandler>> eventHandlers = plugins.find(DomainEventHandler.class, manifest);
        for (Class<DomainEventHandler> h : eventHandlers) {
            container.registerClass(h, h, false);
            container.registerClass(gt, h, false);
        }
        gt = Utils.makeGenericType(DomainEventHandler.class, arrayManifest, new Type[0]);
        eventHandlers = plugins.find(DomainEventHandler.class, arrayManifest);
        for (Class<DomainEventHandler> h : eventHandlers) {
            container.registerClass(h, h, false);
            container.registerClass(gt, h, false);
        }
        ParameterizedType ct = Utils.makeGenericType(Callable.class, manifest, new Type[0]);
        gt = Utils.makeGenericType(DomainEventHandler.class, ct, new Type[0]);
        eventHandlers = plugins.find(DomainEventHandler.class, ct);
        for (Class<DomainEventHandler> h : eventHandlers) {
            container.registerClass(h, h, false);
            container.registerClass(gt, h, false);
        }
        ct = Utils.makeGenericType(Callable.class, arrayManifest, new Type[0]);
        gt = Utils.makeGenericType(DomainEventHandler.class, ct, new Type[0]);
        eventHandlers = plugins.find(DomainEventHandler.class, ct);
        for (Class<DomainEventHandler> h : eventHandlers) {
            container.registerClass(h, h, false);
            container.registerClass(gt, h, false);
        }
    }

    private static class SimpleDomainModel
    implements DomainModel {
        private String[] namespaces = new String[0];
        private final ClassLoader loader;
        private final ConcurrentMap<String, Class<?>> cache = new ConcurrentHashMap();

        SimpleDomainModel(ClassLoader loader) {
            this.loader = loader;
        }

        void setNamespace(String namespaces) {
            String[] parts = namespaces == null ? new String[]{} : namespaces.split(",");
            this.namespaces = new String[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                String ns = parts[i];
                this.namespaces[i] = ns.length() > 0 ? ns + "." : "";
            }
        }

        @Override
        public Optional<Class<?>> find(String name) {
            if (name == null) {
                return Optional.empty();
            }
            Class found = (Class)this.cache.get(name);
            if (found != null) {
                return Optional.of(found);
            }
            String className = name.indexOf(43) != -1 ? name.replace('+', '$') : name;
            for (String ns : this.namespaces) {
                try {
                    Class<?> manifest = Class.forName(ns + className, true, this.loader);
                    this.cache.put(name, manifest);
                    return Optional.of(manifest);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return Optional.empty();
        }
    }
}

