/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.Closeable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Generic;
import org.revenj.patterns.Query;
import org.revenj.patterns.SearchableRepository;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;
import org.revenj.security.GlobalPermission;
import org.revenj.security.PermissionManager;
import org.revenj.security.RolePermission;
import org.revenj.security.UserPrincipal;
import rx.Observable;
import rx.Subscription;

final class RevenjPermissionManager
implements PermissionManager,
Closeable {
    private final Optional<SearchableRepository<GlobalPermission>> globalRepository;
    private final Optional<SearchableRepository<RolePermission>> rolesRepository;
    private final boolean defaultPermissions;
    private final Subscription globalSubscription;
    private final Subscription roleSubscription;
    private Map<String, Boolean> globalPermissions;
    private Map<String, List<Pair>> rolePermissions;
    private Map<String, Boolean> cache = new HashMap<String, Boolean>();
    private final Map<Class<?>, List<Filter>> registeredFilters = new HashMap();
    private boolean permissionsChanged = true;

    public RevenjPermissionManager(ServiceLocator locator) {
        this(locator.resolve(Properties.class), (Observable<Callable<GlobalPermission>>)((Observable)new Generic<Observable<Callable<GlobalPermission>>>(){}.resolve(locator)), (Observable<Callable<RolePermission>>)((Observable)new Generic<Observable<Callable<RolePermission>>>(){}.resolve(locator)), (Optional)new Generic<Optional<SearchableRepository<GlobalPermission>>>(){}.resolve(locator), (Optional)new Generic<Optional<SearchableRepository<RolePermission>>>(){}.resolve(locator));
    }

    public RevenjPermissionManager(Properties properties, Observable<Callable<GlobalPermission>> globalChanges, Observable<Callable<RolePermission>> roleChanges, Optional<SearchableRepository<GlobalPermission>> globalRepository, Optional<SearchableRepository<RolePermission>> rolesRepository) {
        String permissions = properties.getProperty("revenj.permissions");
        if (!(permissions == null || permissions.length() <= 0 || permissions.equalsIgnoreCase("open") && permissions.equalsIgnoreCase("closed"))) {
            throw new RuntimeException("Invalid revenj.permission settings found: " + permissions + ".\nAllowed values are open and closed");
        }
        this.defaultPermissions = permissions == null || "open".equals(permissions);
        this.globalSubscription = globalChanges.subscribe(c -> {
            this.permissionsChanged = true;
        });
        this.roleSubscription = roleChanges.subscribe(c -> {
            this.permissionsChanged = true;
        });
        this.globalRepository = globalRepository;
        this.rolesRepository = rolesRepository;
    }

    private void checkPermissions() {
        if (!this.permissionsChanged) {
            return;
        }
        if (this.globalRepository.isPresent()) {
            this.globalPermissions = this.globalRepository.get().search().stream().collect(Collectors.toMap(GlobalPermission::getName, GlobalPermission::getIsAllowed));
        }
        if (this.rolesRepository.isPresent()) {
            this.rolePermissions = this.rolesRepository.get().search().stream().collect(Collectors.groupingBy(RolePermission::getName, Collectors.mapping(it -> new Pair(it.getRoleID(), it.getIsAllowed()), Collectors.toList())));
        }
        this.cache = new HashMap<String, Boolean>();
        this.permissionsChanged = false;
    }

    private boolean checkOpen(String[] parts, int len) {
        if (len < 1) {
            return this.defaultPermissions;
        }
        String name = String.join((CharSequence)".", Arrays.copyOf(parts, len));
        Boolean found = this.globalPermissions.get(name);
        return found != null ? found.booleanValue() : this.checkOpen(parts, len - 1);
    }

    private boolean implies(Principal principal, String role) {
        return principal instanceof UserPrincipal ? ((UserPrincipal)principal).implies(role) : role.equals(principal.getName());
    }

    @Override
    public boolean canAccess(String identifier, Principal user) {
        if (user == null) {
            return this.defaultPermissions;
        }
        this.checkPermissions();
        String target = identifier != null ? identifier : "";
        String id = user.getName() + ":" + target;
        Boolean exists = this.cache.get(id);
        if (exists != null) {
            return exists;
        }
        String[] parts = target.split(".");
        boolean isAllowed = this.checkOpen(parts, parts.length);
        for (int i = parts.length; i > 0; --i) {
            Optional<Pair> found;
            String subName = String.join((CharSequence)".", Arrays.copyOf(parts, i));
            List<Pair> permissions = this.rolePermissions.get(subName);
            if (permissions == null || !(found = permissions.stream().filter(it -> this.implies(user, it.name)).findFirst()).isPresent()) continue;
            isAllowed = found.get().isAllowed;
            break;
        }
        HashMap<String, Boolean> newCache = new HashMap<String, Boolean>(this.cache);
        newCache.put(id, isAllowed);
        this.cache = newCache;
        return isAllowed;
    }

    @Override
    public <T extends DataSource, S extends T> Query<S> applyFilters(Class<T> manifest, Principal user, Query<S> data) {
        if (user == null) {
            return data.filter(it -> this.defaultPermissions);
        }
        List<Filter> registered = this.registeredFilters.get(manifest);
        if (registered != null) {
            Query<S> result = data;
            for (Filter r : registered) {
                if (this.implies(user, r.role) == r.inverse) continue;
                result = result.filter(r.specification);
            }
            return result;
        }
        return data;
    }

    @Override
    public <T extends DataSource, S extends T> List<S> applyFilters(Class<T> manifest, Principal user, List<S> data) {
        if (user == null) {
            return this.defaultPermissions ? data : Collections.EMPTY_LIST;
        }
        List<Filter> registered = this.registeredFilters.get(manifest);
        if (registered != null) {
            Stream result = data.stream();
            boolean filtered = false;
            for (Filter r : registered) {
                if (this.implies(user, r.role) == r.inverse) continue;
                result = result.filter(r.specification);
                filtered = true;
            }
            return filtered ? result.collect(Collectors.toList()) : data;
        }
        return data;
    }

    @Override
    public <T extends DataSource> Closeable registerFilter(Class<T> manifest, Specification<T> filter, String role, boolean inverse) {
        List<Filter> registered = this.registeredFilters.get(manifest);
        if (registered == null) {
            registered = new ArrayList<Filter>();
            this.registeredFilters.put(manifest, registered);
        }
        Filter item = new Filter(filter, role, inverse);
        List<Filter> reg = registered;
        reg.add(item);
        return () -> reg.remove(item);
    }

    @Override
    public void close() {
        this.globalSubscription.unsubscribe();
        this.roleSubscription.unsubscribe();
    }

    private final class Filter<T> {
        public final Specification<T> specification;
        public final String role;
        public final boolean inverse;

        public Filter(Specification<T> specification, String role, boolean inverse) {
            this.specification = specification;
            this.role = role;
            this.inverse = inverse;
        }
    }

    private final class Pair {
        public final String name;
        public final boolean isAllowed;

        public Pair(String name, boolean isAllowed) {
            this.name = name;
            this.isAllowed = isAllowed;
        }
    }
}

