/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.jinq.RevenjQueryComposer;
import org.revenj.database.postgres.jinq.jpqlquery.ColumnExpressions;
import org.revenj.database.postgres.jinq.jpqlquery.From;
import org.revenj.database.postgres.jinq.jpqlquery.FromAliasExpression;
import org.revenj.database.postgres.jinq.jpqlquery.GeneratedQueryParameter;
import org.revenj.database.postgres.jinq.jpqlquery.SelectFromWhere;
import org.revenj.database.postgres.jinq.jpqlquery.SimpleRowReader;
import org.revenj.database.postgres.jinq.transform.LambdaAnalysis;
import org.revenj.database.postgres.jinq.transform.LambdaInfo;
import org.revenj.database.postgres.jinq.transform.MetamodelUtil;
import org.revenj.database.postgres.jinq.transform.QueryTransformException;
import org.revenj.database.postgres.jinq.transform.RevenjQueryTransformConfiguration;
import org.revenj.database.postgres.jinq.transform.WhereTransform;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.OlapCubeQuery;
import org.revenj.patterns.ServiceLocator;
import org.revenj.patterns.Specification;

public abstract class PostgresOlapCubeQuery<TSource extends DataSource>
implements OlapCubeQuery<TSource> {
    protected final ServiceLocator locator;
    protected final PostgresReader reader;
    protected final Connection transactionConnection;
    protected final javax.sql.DataSource dataSource;
    private final MetamodelUtil metamodel;
    private final ClassLoader loader;
    protected final Map<String, Function<String, String>> cubeDimensions = new LinkedHashMap<String, Function<String, String>>();
    protected final Map<String, Function<String, String>> cubeFacts = new LinkedHashMap<String, Function<String, String>>();
    protected final Map<String, Converter> cubeConverters = new LinkedHashMap<String, Converter>();

    protected abstract String getSource();

    protected PostgresOlapCubeQuery(ServiceLocator locator) {
        this.locator = locator;
        this.reader = new PostgresReader(locator);
        this.loader = locator.resolve(ClassLoader.class);
        this.transactionConnection = locator.tryResolve(Connection.class).orElse(null);
        this.dataSource = this.transactionConnection != null ? null : locator.resolve(javax.sql.DataSource.class);
        this.metamodel = locator.resolve(MetamodelUtil.class);
    }

    @Override
    public Set<String> getDimensions() {
        return this.cubeDimensions.keySet();
    }

    @Override
    public Set<String> getFacts() {
        return this.cubeFacts.keySet();
    }

    private void validateInput(List<String> usedDimensions, List<String> usedFacts, Collection<String> customOrder) {
        if (usedDimensions.size() == 0 && usedFacts.size() == 0) {
            throw new IllegalArgumentException("Cube must have at least one dimension or fact.");
        }
        for (String d : usedDimensions) {
            if (this.cubeDimensions.containsKey(d)) continue;
            throw new IllegalArgumentException("Unknown dimension: " + d + ". Use getDimensions method for available dimensions");
        }
        for (String f : usedFacts) {
            if (this.cubeFacts.containsKey(f)) continue;
            throw new IllegalArgumentException("Unknown fact: " + f + ". Use getFacts method for available facts");
        }
        for (String o : customOrder) {
            if (usedDimensions.contains(o) || usedFacts.contains(o)) continue;
            throw new IllegalArgumentException("Invalid order: " + o + ". Order can be only field from used dimensions and facts.");
        }
    }

    protected Connection getConnection() {
        if (this.transactionConnection != null) {
            return this.transactionConnection;
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to resolve connection for cube query. " + e.getMessage());
        }
    }

    protected void releaseConnection(Connection connection) throws SQLException {
        if (this.transactionConnection == null) {
            connection.close();
        }
    }

    private static RevenjQueryTransformConfiguration buildConfig(MetamodelUtil metamodel) {
        RevenjQueryTransformConfiguration config = new RevenjQueryTransformConfiguration();
        config.metamodel = metamodel;
        config.alternateClassLoader = null;
        config.isObjectEqualsSafe = true;
        config.isCollectionContainsSafe = true;
        return config;
    }

    private SelectFromWhere<TSource> applyTransformWithLambda(String name, LambdaInfo lambdaInfo) {
        if (lambdaInfo == null) {
            return null;
        }
        try {
            RevenjQueryTransformConfiguration config = PostgresOlapCubeQuery.buildConfig(this.metamodel);
            LambdaAnalysis lambdaAnalysis = lambdaInfo.fullyAnalyze(this.metamodel, this.loader, true, true, true, true);
            if (lambdaAnalysis == null) {
                return null;
            }
            config.checkLambdaSideEffects(lambdaAnalysis);
            SelectFromWhere query = new SelectFromWhere();
            From.FromDataSource from = new From.FromDataSource();
            from.name = name;
            query.cols = ColumnExpressions.singleColumn(SimpleRowReader.READER, new FromAliasExpression(from));
            query.froms.add(from);
            WhereTransform where = new WhereTransform(config, false);
            return where.apply(lambdaAnalysis, null, query);
        }
        catch (TypedValueVisitorException | QueryTransformException e) {
            throw new RuntimeException(e);
        }
    }

    protected Specification<TSource> rewriteSpecification(Specification<TSource> specification) {
        return specification;
    }

    public void prepareSql(StringBuilder sb, List<String> usedDimensions, List<String> usedFacts, Collection<Map.Entry<String, Boolean>> order, Specification<TSource> filter, Integer limit, Integer offset, List<GeneratedQueryParameter> parameters, List<LambdaInfo> lambdas) {
        LinkedHashMap<String, Boolean> customOrder = new LinkedHashMap<String, Boolean>();
        if (order != null) {
            for (Map.Entry<String, Boolean> entry : order) {
                if (entry.getKey() == null) continue;
                customOrder.put(entry.getKey(), entry.getValue());
            }
        }
        this.validateInput(usedDimensions, usedFacts, customOrder.keySet());
        String alias = "_it";
        sb.append("SELECT ROW(");
        for (String string : usedDimensions) {
            sb.append(this.cubeDimensions.get(string).apply(alias)).append(',');
        }
        for (String string : usedFacts) {
            sb.append(this.cubeFacts.get(string).apply(alias)).append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append(") FROM ").append(this.getSource()).append(" \"").append(alias).append("\"");
        if (filter != null) {
            LambdaInfo lambdaInfo = LambdaInfo.analyze(this.rewriteSpecification(filter), 0, true);
            SelectFromWhere<TSource> selectFromWhere = this.applyTransformWithLambda(alias, lambdaInfo);
            if (selectFromWhere != null && selectFromWhere.generateWhere("\"" + alias + "\"")) {
                sb.append(" WHERE ");
                sb.append(selectFromWhere.getQueryString());
                parameters.addAll(selectFromWhere.getQueryParameters());
            }
            lambdas.add(lambdaInfo);
        }
        if (!usedDimensions.isEmpty()) {
            sb.append(" GROUP BY ");
            for (String string : usedDimensions) {
                sb.append(this.cubeDimensions.get(string).apply(alias));
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append('\n');
        }
        if (!customOrder.isEmpty()) {
            sb.append(" ORDER BY ");
            for (Map.Entry entry : customOrder.entrySet()) {
                if (this.cubeDimensions.containsKey(entry.getKey())) {
                    sb.append(this.cubeDimensions.get(entry.getKey()).apply(alias));
                } else if (this.cubeFacts.containsKey(entry.getKey())) {
                    sb.append(this.cubeFacts.get(entry.getKey()).apply(alias));
                } else {
                    sb.append("\"").append((String)entry.getKey()).append("\"");
                }
                sb.append((Boolean)entry.getValue() != false ? "" : "DESC");
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        if (limit != null) {
            sb.append(" LIMIT ").append(Integer.toString(limit));
        }
        if (offset != null) {
            sb.append(" OFFSET ").append(Integer.toString(offset));
        }
    }

    public Converter[] prepareConverters(List<String> dimensions, List<String> facts) {
        int i;
        Converter[] converters = new Converter[dimensions.size() + facts.size()];
        for (i = 0; i < dimensions.size(); ++i) {
            converters[i] = this.cubeConverters.get(dimensions.get(i));
        }
        for (i = 0; i < facts.size(); ++i) {
            converters[i + dimensions.size()] = this.cubeConverters.get(facts.get(i));
        }
        return converters;
    }

    @Override
    public List<Map<String, Object>> analyze(List<String> dimensions, List<String> facts, Collection<Map.Entry<String, Boolean>> order, Specification<TSource> filter, Integer limit, Integer offset) {
        ArrayList<String> usedDimensions = new ArrayList<String>();
        ArrayList<String> usedFacts = new ArrayList<String>();
        if (dimensions != null) {
            usedDimensions.addAll(dimensions);
        }
        if (facts != null) {
            usedFacts.addAll(facts);
        }
        ArrayList<GeneratedQueryParameter> parameters = filter != null ? new ArrayList<GeneratedQueryParameter>() : null;
        ArrayList<LambdaInfo> lambdas = filter != null ? new ArrayList<LambdaInfo>(1) : null;
        StringBuilder sb = new StringBuilder();
        this.prepareSql(sb, usedDimensions, usedFacts, order, filter, limit, offset, parameters, lambdas);
        Converter[] converters = this.prepareConverters(usedDimensions, usedFacts);
        Connection connection = this.getConnection();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (PreparedStatement ps = connection.prepareStatement(sb.toString());){
            int i;
            if (parameters != null && parameters.size() > 0) {
                RevenjQueryComposer.fillQueryParameters(connection, this.locator, ps, 0, parameters, lambdas);
            }
            ResultSet rs = ps.executeQuery();
            String[] columnNames = new String[usedFacts.size() + usedDimensions.size()];
            for (i = 0; i < usedDimensions.size(); ++i) {
                columnNames[i] = (String)usedDimensions.get(i);
            }
            for (i = 0; i < usedFacts.size(); ++i) {
                columnNames[usedDimensions.size() + i] = (String)usedFacts.get(i);
            }
            while (rs.next()) {
                this.reader.process(rs.getString(1));
                this.reader.read();
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                for (int i2 = 0; i2 < columnNames.length; ++i2) {
                    item.put(columnNames[i2], converters[i2].convert(this.reader, 1));
                }
                result.add(item);
            }
            rs.close();
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @FunctionalInterface
    public static interface Converter {
        public Object convert(PostgresReader var1, int var2) throws IOException;
    }
}

