/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres;

import java.util.Arrays;
import org.revenj.database.postgres.PostgresBuffer;

public final class PostgresWriter
implements PostgresBuffer,
AutoCloseable {
    private char[] buffer = new char[64];
    public final char[] tmp = new char[64];
    private int position = 0;
    private static ThreadLocal<PostgresWriter> threadWriter = new ThreadLocal<PostgresWriter>(){

        @Override
        protected PostgresWriter initialValue() {
            return new PostgresWriter();
        }
    };

    public static PostgresWriter create() {
        PostgresWriter writer = threadWriter.get();
        writer.reset();
        return writer;
    }

    @Override
    public void close() {
        this.position = 0;
    }

    public void reset() {
        this.position = 0;
    }

    public void write(String input) {
        int len = input.length();
        if (this.position + len >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + len);
        }
        input.getChars(0, len, this.buffer, this.position);
        this.position += len;
    }

    public void write(byte c) {
        if (this.position == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
        this.buffer[this.position++] = (char)c;
    }

    public void write(char c) {
        if (this.position == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
        this.buffer[this.position++] = c;
    }

    public void write(char[] buf) {
        if (this.position + buf.length >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + buf.length);
        }
        for (int i = 0; i < buf.length; ++i) {
            this.buffer[this.position + i] = buf[i];
        }
        this.position += buf.length;
    }

    public void write(char[] buf, int len) {
        if (this.position + len >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.position + i] = buf[i];
        }
        this.position += len;
    }

    public void write(char[] buf, int off, int end) {
        if (this.position + end >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + end);
        }
        for (int i = off; i < end; ++i) {
            this.buffer[this.position + i - off] = buf[i];
        }
        this.position += end - off;
    }

    public void writeBuffer(int len) {
        if (this.position + len >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.position + i] = this.tmp[i];
        }
        this.position += len;
    }

    public String toString() {
        return new String(this.buffer, 0, this.position);
    }

    public static void writeSimpleUriList(StringBuilder sb, String[] uris) {
        sb.append('\'');
        String uri = uris[0];
        int ind = uri.indexOf(39);
        if (ind == -1) {
            sb.append(uri);
        } else {
            for (int i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
        }
        for (int x = 1; x < uris.length; ++x) {
            uri = uris[x];
            sb.append("','");
            ind = uri.indexOf(39);
            if (ind == -1) {
                sb.append(uri);
                continue;
            }
            for (int i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
        }
        sb.append('\'');
    }

    public static void writeSimpleUri(StringBuilder sb, String uri) {
        sb.append('\'');
        int ind = uri.indexOf(39);
        if (ind == -1) {
            sb.append(uri);
        } else {
            for (int i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
        }
        sb.append('\'');
    }

    private static int findEscapedChar(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '\\' && c != '/' && c != '\'') continue;
            return i;
        }
        return -1;
    }

    public static void writeCompositeUriList(StringBuilder sb, String[] uris) {
        int i;
        sb.append("('");
        String uri = uris[0];
        int ind = PostgresWriter.findEscapedChar(uri);
        if (ind == -1) {
            sb.append(uri);
        } else {
            for (i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == '\\') {
                    sb.append(uri.charAt(++i));
                    continue;
                }
                if (c == '/') {
                    sb.append("','");
                    continue;
                }
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
        }
        for (int x = 1; x < uris.length; ++x) {
            sb.append("'),('");
            uri = uris[x];
            ind = PostgresWriter.findEscapedChar(uri);
            if (ind == -1) {
                sb.append(uri);
                continue;
            }
            for (i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == '\\') {
                    sb.append(uri.charAt(++i));
                    continue;
                }
                if (c == '/') {
                    sb.append("','");
                    continue;
                }
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
        }
        sb.append("')");
    }

    public static void writeCompositeUri(StringBuilder sb, String uri) {
        sb.append("('");
        int ind = PostgresWriter.findEscapedChar(uri);
        if (ind == -1) {
            sb.append(uri);
        } else {
            for (int i = 0; i < uri.length(); ++i) {
                char c = uri.charAt(i);
                if (c == '\\') {
                    sb.append(uri.charAt(++i));
                    continue;
                }
                if (c == '/') {
                    sb.append("','");
                    continue;
                }
                if (c == '\'') {
                    sb.append("''");
                    continue;
                }
                sb.append(c);
            }
        }
        sb.append("')");
    }

    @Override
    public char[] getTempBuffer() {
        return this.tmp;
    }

    @Override
    public void initBuffer() {
        this.reset();
    }

    @Override
    public void initBuffer(char c) {
        this.reset();
        this.write(c);
    }

    @Override
    public void addToBuffer(char c) {
        this.write(c);
    }

    @Override
    public void addToBuffer(char[] buf) {
        this.write(buf);
    }

    @Override
    public void addToBuffer(char[] buf, int len) {
        this.write(buf, len);
    }

    @Override
    public void addToBuffer(char[] buf, int off, int end) {
        this.write(buf, off, end);
    }

    @Override
    public void addToBuffer(String input) {
        this.write(input);
    }

    @Override
    public String bufferToString() {
        String result = this.toString();
        this.position = 0;
        return result;
    }
}

