/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public abstract class DecimalConverter {
    public static void serializeURI(PostgresBuffer sw, BigDecimal value) {
        if (value == null) {
            return;
        }
        sw.addToBuffer(value.toPlainString());
    }

    public static BigDecimal parse(PostgresReader reader, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : BigDecimal.ZERO;
        }
        return DecimalConverter.parseDecimal(reader, cur, ')');
    }

    private static BigDecimal parseDecimal(PostgresReader reader, int cur, char matchEnd) throws IOException {
        reader.initBuffer((char)cur);
        reader.fillUntil(',', matchEnd);
        reader.read();
        return reader.bufferToValue(BigDecimal::new);
    }

    public static List<BigDecimal> parseCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<BigDecimal>(0);
        }
        BigDecimal defaultValue = allowNulls ? null : BigDecimal.ZERO;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        do {
            if ((cur = reader.read()) == 78) {
                list.add(defaultValue);
                cur = reader.read(4);
                continue;
            }
            list.add(DecimalConverter.parseDecimal(reader, cur, '}'));
            cur = reader.last();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new DecimalTuple(value);
    }

    private static class DecimalTuple
    extends PostgresTuple {
        private final BigDecimal value;

        DecimalTuple(BigDecimal value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(this.value.toPlainString());
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(this.value.toPlainString());
        }

        @Override
        public String buildTuple(boolean quote) {
            return this.value.toPlainString();
        }
    }
}

