/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.revenj.Utils;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.StringConverter;
import org.revenj.database.postgres.converters.ValueTuple;

public abstract class InetConverter {
    public static void serializeURI(PostgresBuffer sw, InetAddress value) throws IOException {
        if (value == null) {
            return;
        }
        sw.addToBuffer(value.getHostAddress());
    }

    public static InetAddress parse(PostgresReader reader, int context, boolean nullable) throws IOException {
        String value = StringConverter.parse(reader, context, true);
        if (value == null) {
            return nullable ? null : Utils.LOOPBACK;
        }
        return InetAddress.getByName(value);
    }

    public static List<InetAddress> parseCollection(PostgresReader reader, int context, boolean nullable) throws IOException {
        InetAddress defaultValue;
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<InetAddress>(0);
        }
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        InetAddress inetAddress = defaultValue = nullable ? null : Utils.LOOPBACK;
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read(4);
                list.add(defaultValue);
                continue;
            }
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            list.add(InetAddress.getByName(reader.bufferToString()));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTupleNullable(InetAddress value) {
        return value == null ? null : ValueTuple.from(value.getHostAddress());
    }

    public static PostgresTuple toTuple(InetAddress value) {
        return ValueTuple.from(value.getHostAddress());
    }
}

