/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.NumberConverter;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.ValueTuple;

public abstract class IntConverter {
    private static final PostgresTuple MIN_TUPLE = new ValueTuple("-2147483648", false, false);

    public static void serializeURI(PostgresBuffer sw, int value) throws IOException {
        if (value == Integer.MIN_VALUE) {
            sw.addToBuffer("-2147483648");
        } else {
            int offset = NumberConverter.serialize(value, sw.getTempBuffer());
            sw.addToBuffer(sw.getTempBuffer(), offset, 11);
        }
    }

    public static void serializeURI(PostgresBuffer sw, Integer value) throws IOException {
        if (value == null) {
            return;
        }
        IntConverter.serializeURI(sw, (int)value);
    }

    public static Integer parseNullable(PostgresReader reader) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        return IntConverter.parseInt(reader, cur, ')');
    }

    public static int parse(PostgresReader reader) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return 0;
        }
        return IntConverter.parseInt(reader, cur, ')');
    }

    private static int parseInt(PostgresReader reader, int cur, char matchEnd) {
        int res = 0;
        if (cur == 45) {
            cur = reader.read();
            do {
                res = (res << 3) + (res << 1) - (cur - 48);
            } while ((cur = reader.read()) != -1 && cur != 44 && cur != matchEnd);
        } else {
            do {
                res = (res << 3) + (res << 1) + (cur - 48);
            } while ((cur = reader.read()) != -1 && cur != 44 && cur != matchEnd);
        }
        return res;
    }

    public static List<Integer> parseCollection(PostgresReader reader, int context, boolean allowNulls) {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Integer>(0);
        }
        Integer defaultValue = allowNulls ? null : Integer.valueOf(0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        do {
            if ((cur = reader.read()) == 78) {
                list.add(defaultValue);
                cur = reader.read(4);
                continue;
            }
            list.add(IntConverter.parseInt(reader, cur, '}'));
            cur = reader.last();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(Integer value) {
        if (value == null) {
            return null;
        }
        return IntConverter.toTuple((int)value);
    }

    public static PostgresTuple toTuple(int value) {
        if (value == Integer.MIN_VALUE) {
            return MIN_TUPLE;
        }
        return new IntTuple(value);
    }

    private static class IntTuple
    extends PostgresTuple {
        private final int value;

        IntTuple(int value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            int offset = NumberConverter.serialize(this.value, sw.tmp);
            sw.write(sw.tmp, offset, 11);
        }

        @Override
        public String buildTuple(boolean quote) {
            return Integer.toString(this.value);
        }
    }
}

