/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.ValueTuple;

public abstract class StringConverter {
    public static void serializeURI(PostgresBuffer sw, String value) {
        if (value == null) {
            return;
        }
        sw.addToBuffer(value);
    }

    public static void serializeCompositeURI(PostgresBuffer sw, String value) {
        if (value == null) {
            return;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\' || c == '/') {
                sw.addToBuffer('\\');
            }
            sw.addToBuffer(c);
        }
    }

    public static void skip(PostgresReader reader, int context) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return;
        }
        if (cur == 34 || cur == 92) {
            cur = reader.read(context);
            while (cur != -1) {
                if (cur == 92 || cur == 34) {
                    cur = reader.read(context);
                    if (cur == 44 || cur == 41) {
                        return;
                    }
                    cur = reader.read(context);
                    continue;
                }
                cur = reader.read();
            }
            throw new IOException("Unable to find end of string");
        }
        reader.initBuffer();
        reader.fillUntil(',', ')');
        reader.read();
    }

    public static String parse(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : "";
        }
        if (cur != 34 && cur != 92) {
            reader.initBuffer((char)cur);
            reader.fillUntil(',', ')');
            reader.read();
            return reader.bufferToString();
        }
        return StringConverter.parseEscapedString(reader, context, ')');
    }

    static String parseEscapedString(PostgresReader reader, int context, char matchEnd) throws IOException {
        int cur = reader.read(context);
        reader.initBuffer();
        do {
            if (cur == 92 || cur == 34) {
                cur = reader.read(context);
                if (cur == 44 || cur == matchEnd) {
                    return reader.bufferToString();
                }
                for (int i = 0; i < context - 1; ++i) {
                    cur = reader.read();
                }
            }
            reader.addToBuffer((char)cur);
            reader.fillUntil('\\', '\"');
        } while ((cur = reader.read()) != -1);
        throw new IOException("Unable to find end of string");
    }

    public static List<String> parseCollection(PostgresReader reader, int context, boolean allowNull) throws IOException {
        String emptyCol;
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<String>(0);
        }
        int innerContext = context << 1;
        ArrayList<String> list = new ArrayList<String>();
        String string = emptyCol = allowNull ? null : "";
        do {
            if ((cur = reader.read()) == 34 || cur == 92) {
                list.add(StringConverter.parseEscapedString(reader, innerContext, '}'));
                cur = reader.last();
                continue;
            }
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            cur = reader.read();
            if (reader.bufferMatches("NULL")) {
                list.add(emptyCol);
                continue;
            }
            list.add(reader.bufferToString());
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(String value) {
        return ValueTuple.from(value);
    }
}

