/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.util.PGobject;
import org.revenj.TreePath;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.ValueTuple;

public abstract class TreePathConverter {
    public static void setParameter(PostgresBuffer sw, PreparedStatement ps, int index, TreePath value) throws SQLException {
        PGobject pg = new PGobject();
        pg.setType("ltree");
        pg.setValue(value.toString());
        ps.setObject(index, pg);
    }

    public static void serializeURI(PostgresBuffer sw, TreePath value) throws IOException {
        if (value == null) {
            return;
        }
        sw.addToBuffer(value.toString());
    }

    public static TreePath parse(PostgresReader reader, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : TreePath.EMPTY;
        }
        reader.initBuffer((char)cur);
        reader.fillUntil(',', ')');
        reader.read();
        return TreePath.create(reader.bufferToString());
    }

    public static List<TreePath> parseCollection(PostgresReader reader, int context, boolean allowNull) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<TreePath>(0);
        }
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        TreePath emptyCol = allowNull ? null : TreePath.EMPTY;
        do {
            cur = reader.read();
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            cur = reader.read();
            if (reader.bufferMatches("NULL")) {
                list.add(emptyCol);
                continue;
            }
            list.add(TreePath.create(reader.bufferToString()));
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(TreePath value) {
        return value != null ? new ValueTuple(value.toString(), false, false) : null;
    }
}

