/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public abstract class UuidConverter {
    public static final UUID MIN_UUID;
    private static final char[] Lookup;
    private static final byte[] Values;

    public static void serializeURI(PostgresBuffer sw, UUID value) {
        if (value == null) {
            return;
        }
        UuidConverter.serialize(value, sw.getTempBuffer(), 0);
        sw.addToBuffer(sw.getTempBuffer(), 36);
    }

    private static void serialize(UUID value, char[] buf, int start) {
        long hi = value.getMostSignificantBits();
        long lo = value.getLeastSignificantBits();
        int hi1 = (int)(hi >> 32);
        int hi2 = (int)hi;
        int lo1 = (int)(lo >> 32);
        int lo2 = (int)lo;
        int v = hi1 >> 24 & 0xFF;
        char l = Lookup[v];
        buf[start] = (char)(l >> 8);
        buf[start + 1] = l;
        v = hi1 >> 16 & 0xFF;
        l = Lookup[v];
        buf[start + 2] = (char)(l >> 8);
        buf[start + 3] = l;
        v = hi1 >> 8 & 0xFF;
        l = Lookup[v];
        buf[start + 4] = (char)(l >> 8);
        buf[start + 5] = l;
        v = hi1 & 0xFF;
        l = Lookup[v];
        buf[start + 6] = (char)(l >> 8);
        buf[start + 7] = l;
        buf[start + 8] = 45;
        v = hi2 >> 24 & 0xFF;
        l = Lookup[v];
        buf[start + 9] = (char)(l >> 8);
        buf[start + 10] = l;
        v = hi2 >> 16 & 0xFF;
        l = Lookup[v];
        buf[start + 11] = (char)(l >> 8);
        buf[start + 12] = l;
        buf[start + 13] = 45;
        v = hi2 >> 8 & 0xFF;
        l = Lookup[v];
        buf[start + 14] = (char)(l >> 8);
        buf[start + 15] = l;
        v = hi2 & 0xFF;
        l = Lookup[v];
        buf[start + 16] = (char)(l >> 8);
        buf[start + 17] = l;
        buf[start + 18] = 45;
        v = lo1 >> 24 & 0xFF;
        l = Lookup[v];
        buf[start + 19] = (char)(l >> 8);
        buf[start + 20] = l;
        v = lo1 >> 16 & 0xFF;
        l = Lookup[v];
        buf[start + 21] = (char)(l >> 8);
        buf[start + 22] = l;
        buf[start + 23] = 45;
        v = lo1 >> 8 & 0xFF;
        l = Lookup[v];
        buf[start + 24] = (char)(l >> 8);
        buf[start + 25] = l;
        v = lo1 & 0xFF;
        l = Lookup[v];
        buf[start + 26] = (char)(l >> 8);
        buf[start + 27] = l;
        v = lo2 >> 24 & 0xFF;
        l = Lookup[v];
        buf[start + 28] = (char)(l >> 8);
        buf[start + 29] = l;
        v = lo2 >> 16 & 0xFF;
        l = Lookup[v];
        buf[start + 30] = (char)(l >> 8);
        buf[start + 31] = l;
        v = lo2 >> 8 & 0xFF;
        l = Lookup[v];
        buf[start + 32] = (char)(l >> 8);
        buf[start + 33] = l;
        v = lo2 & 0xFF;
        l = Lookup[v];
        buf[start + 34] = (char)(l >> 8);
        buf[start + 35] = l;
    }

    public static int serializeURI(char[] buf, int pos, UUID value) throws IOException {
        if (value == null) {
            return pos;
        }
        UuidConverter.serialize(value, buf, pos);
        return pos + 36;
    }

    public static UUID parse(PostgresReader reader, boolean nullable) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return nullable ? null : MIN_UUID;
        }
        char[] buf = reader.tmp;
        buf[0] = (char)cur;
        reader.fillTotal(buf, 1, 36);
        return UuidConverter.toUuid(buf);
    }

    private static UUID toUuid(char[] buf) throws IOException {
        try {
            int i;
            int i2;
            long hi = 0L;
            for (i2 = 0; i2 < 8; ++i2) {
                hi = (hi << 4) + (long)Values[buf[i2] - 48];
            }
            for (i2 = 9; i2 < 13; ++i2) {
                hi = (hi << 4) + (long)Values[buf[i2] - 48];
            }
            for (i2 = 14; i2 < 18; ++i2) {
                hi = (hi << 4) + (long)Values[buf[i2] - 48];
            }
            long lo = 0L;
            for (i = 19; i < 23; ++i) {
                lo = (lo << 4) + (long)Values[buf[i] - 48];
            }
            for (i = 24; i < 36; ++i) {
                lo = (lo << 4) + (long)Values[buf[i] - 48];
            }
            return new UUID(hi, lo);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return UUID.fromString(new String(buf, 0, 36));
        }
    }

    public static List<UUID> parseCollection(PostgresReader reader, int context, boolean nullable) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<UUID>(0);
        }
        ArrayList<UUID> list = new ArrayList<UUID>();
        UUID defaultValue = nullable ? null : MIN_UUID;
        char[] buf = reader.tmp;
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read(4);
                list.add(defaultValue);
                continue;
            }
            buf[0] = (char)cur;
            reader.fillTotal(buf, 1, 35);
            list.add(UuidConverter.toUuid(buf));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTupleNullable(UUID value) {
        return value == null ? null : new UuidTuple(value);
    }

    public static PostgresTuple toTuple(UUID value) {
        return new UuidTuple(value);
    }

    static {
        int c;
        MIN_UUID = new UUID(0L, 0L);
        Lookup = new char[256];
        Values = new byte[55];
        for (int i = 0; i < 256; ++i) {
            int hi = i >> 4 & 0xF;
            int lo = i & 0xF;
            UuidConverter.Lookup[i] = (char)(((hi < 10 ? 48 + hi : 97 + hi - 10) << 8) + (lo < 10 ? 48 + lo : 97 + lo - 10));
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            UuidConverter.Values[c - 48] = (byte)(c - 48);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            UuidConverter.Values[c - 48] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            UuidConverter.Values[c - 48] = (byte)(c - 65 + 10);
        }
    }

    private static class UuidTuple
    extends PostgresTuple {
        private final UUID value;

        UuidTuple(UUID value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            UuidConverter.serialize(this.value, sw.tmp, 0);
            sw.writeBuffer(36);
        }

        @Override
        public String buildTuple(boolean quote) {
            if (quote) {
                char[] buf = new char[38];
                buf[0] = 39;
                UuidConverter.serialize(this.value, buf, 1);
                buf[37] = 39;
                return new String(buf, 0, buf.length);
            }
            char[] buf = new char[36];
            UuidConverter.serialize(this.value, buf, 0);
            return new String(buf, 0, buf.length);
        }
    }
}

