/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;

public class BinaryExpression
extends Expression {
    final Expression left;
    final Expression right;
    final String operator;
    final String prepare;
    final String finish;

    public BinaryExpression(Expression left, String operator, Expression right) {
        this.operator = operator;
        this.prepare = "";
        this.finish = "";
        this.left = left;
        this.right = right;
    }

    public BinaryExpression(String prepare, Expression left, String between, Expression right, String finish) {
        this.operator = between;
        this.prepare = prepare;
        this.finish = finish;
        this.left = left;
        this.right = right;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        OperatorPrecedenceLevel precedence = OperatorPrecedenceLevel.forOperator(this.operator);
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery("(");
        }
        queryState.appendQuery(this.prepare);
        this.left.generateQuery(queryState, precedence);
        queryState.appendQuery(" ").appendQuery(this.operator).appendQuery(" ");
        this.right.generateQuery(queryState, precedence.getLevelBelow());
        queryState.appendQuery(this.finish);
        if (!precedence.hasPrecedence(operatorPrecedenceScope)) {
            queryState.appendQuery(")");
        }
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.left.prepareQueryGeneration(preparePhase, queryState);
        this.right.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BinaryExpression o = (BinaryExpression)obj;
        return this.operator.equals(o.operator) && this.left.equals(o.left) && this.right.equals(o.right);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitBinary(this);
    }
}

