/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import java.util.Objects;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;

public class ParameterExpression
extends Expression {
    final int lambdaIndex;
    final int argIndex;
    final String argType;

    public ParameterExpression(int lambdaIndex, int argIndex, String argType) {
        this.lambdaIndex = lambdaIndex;
        this.argIndex = argIndex;
        this.argType = argType;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        queryState.registerParameter((Object)this, this.lambdaIndex, this.argIndex, this.argType);
        queryState.appendQuery("?");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParameterExpression o = (ParameterExpression)obj;
        return this.lambdaIndex == o.lambdaIndex && this.argIndex == o.argIndex && Objects.equals(this.argType, o.argType);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitParameter(this);
    }
}

