/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import java.util.Objects;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;

public class ParameterFieldExpression
extends Expression {
    final int lambdaIndex;
    final String fieldName;
    final String fieldType;

    public ParameterFieldExpression(int lambdaIndex, String fieldName, String fieldType) {
        this.lambdaIndex = lambdaIndex;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        queryState.registerParameter((Object)this, this.lambdaIndex, this.fieldName, this.fieldType);
        queryState.appendQuery("?");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ParameterFieldExpression o = (ParameterFieldExpression)obj;
        return this.lambdaIndex == o.lambdaIndex && this.fieldName.equals(o.fieldName) && Objects.equals(this.fieldType, o.fieldType);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitParameterField(this);
    }
}

