/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.ExpressionVisitor;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;

public class ReadFieldExpression
extends Expression {
    public final Expression base;
    public final String field;

    public ReadFieldExpression(Expression base, String field) {
        this.base = base;
        this.field = field;
    }

    @Override
    public void generateQuery(QueryGenerationState queryState, OperatorPrecedenceLevel operatorPrecedenceScope) {
        OperatorPrecedenceLevel precedence = OperatorPrecedenceLevel.forOperator(".");
        queryState.appendQuery("(");
        this.base.generateQuery(queryState, precedence);
        queryState.appendQuery(".");
        queryState.appendQuery(this.field);
        queryState.appendQuery(")");
    }

    @Override
    public void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        this.base.prepareQueryGeneration(preparePhase, queryState);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ReadFieldExpression o = (ReadFieldExpression)obj;
        return this.field.equals(o.field) && this.base.equals(o.base);
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        visitor.visitReadField(this);
    }
}

