/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.jinq.jpqlquery;

import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.jinq.jpqlquery.Expression;
import org.revenj.database.postgres.jinq.jpqlquery.From;
import org.revenj.database.postgres.jinq.jpqlquery.GeneratedQueryParameter;
import org.revenj.database.postgres.jinq.jpqlquery.GroupedSelectFromWhere;
import org.revenj.database.postgres.jinq.jpqlquery.OperatorPrecedenceLevel;
import org.revenj.database.postgres.jinq.jpqlquery.QueryGenerationState;
import org.revenj.database.postgres.jinq.jpqlquery.RowReader;
import org.revenj.database.postgres.jinq.jpqlquery.SelectOnly;
import org.revenj.database.postgres.jinq.jpqlquery.SubqueryExpression;

public class SelectFromWhere<T>
extends SelectOnly<T> {
    public final List<From> froms = new ArrayList<From>(1);
    public Expression where;
    public final List<SortingParameters> sort = new ArrayList<SortingParameters>(1);
    public long limit = -1L;
    public long skip = -1L;
    private String queryString;
    private List<GeneratedQueryParameter> queryParameters;

    protected void generateQuery() {
        QueryGenerationState queryState = new QueryGenerationState();
        this.prepareQueryGeneration(queryState);
        this.queryString = this.generateQueryContents(queryState);
        this.queryParameters = queryState.parameters;
    }

    public boolean generateWhere(String alias) {
        QueryGenerationState queryState = new QueryGenerationState();
        if (this.where == null) {
            return false;
        }
        queryState.fromAliases.put(this.froms.get(0), alias);
        this.where.prepareQueryGeneration(Expression.QueryGenerationPreparationPhase.FROM, queryState);
        this.where.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        this.queryString = queryState.buildQueryString();
        this.queryParameters = queryState.parameters;
        return this.queryString.length() > 0;
    }

    protected void prepareQueryGeneration(QueryGenerationState queryState) {
        this.prepareQueryGeneration(Expression.QueryGenerationPreparationPhase.FROM, queryState);
    }

    protected void prepareQueryGeneration(Expression.QueryGenerationPreparationPhase preparePhase, QueryGenerationState queryState) {
        for (Expression col : this.cols.columns) {
            col.prepareQueryGeneration(preparePhase, queryState);
        }
        for (From from : this.froms) {
            from.prepareQueryGeneration(preparePhase, queryState);
        }
        if (this.where != null) {
            this.where.prepareQueryGeneration(preparePhase, queryState);
        }
        for (SortingParameters sortParams : this.sort) {
            sortParams.expr.prepareQueryGeneration(preparePhase, queryState);
        }
    }

    protected String generateQueryContents(QueryGenerationState queryState) {
        this.generateSelectFromWhere(queryState);
        this.generateSort(queryState);
        this.generateLimitOffset(queryState);
        return queryState.buildQueryString();
    }

    protected void generateSelectFromWhere(QueryGenerationState queryState) {
        boolean isFirst;
        if (this.cols.getNumColumns() > 0) {
            queryState.appendQuery("SELECT ");
            if (this.isDistinct) {
                queryState.appendQuery("DISTINCT ");
            }
            isFirst = true;
            for (Expression col : this.cols.columns) {
                if (!isFirst) {
                    queryState.appendQuery(", ");
                }
                isFirst = false;
                col.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
            }
        }
        if (this.froms.size() > 0) {
            queryState.appendQuery(" FROM ");
            isFirst = true;
            for (From from : this.froms) {
                if (!isFirst && from.isPrecededByComma()) {
                    queryState.appendQuery(", ");
                }
                from.generateFromString(queryState, isFirst);
                isFirst = false;
                queryState.appendQuery(" ").appendQuery(queryState.getFromAlias(from));
            }
        }
        if (this.where != null) {
            queryState.appendQuery(" WHERE ");
            this.where.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_UNRESTRICTED_OPERATOR_PRECEDENCE);
        }
    }

    protected void generateSort(QueryGenerationState queryState) {
        if (!this.sort.isEmpty()) {
            queryState.appendQuery(" ORDER BY");
            boolean isFirst = true;
            for (SortingParameters sortParams : this.sort) {
                if (!isFirst) {
                    queryState.appendQuery(",");
                }
                isFirst = false;
                queryState.appendQuery(" ");
                if (sortParams.expr instanceof SubqueryExpression) {
                    queryState.appendQuery("(");
                }
                sortParams.expr.generateQuery(queryState, OperatorPrecedenceLevel.JPQL_ORDER_BY_UNRESTRICTED_OPERATOR_PRECEDENCE);
                queryState.appendQuery(sortParams.isAscending ? " ASC" : " DESC");
                if (!(sortParams.expr instanceof SubqueryExpression)) continue;
                queryState.appendQuery(")");
            }
        }
    }

    protected void generateLimitOffset(QueryGenerationState queryState) {
        if (this.limit >= 0L) {
            queryState.appendQuery(" LIMIT ");
            queryState.appendQuery(Long.toString(this.limit));
        }
        if (this.skip >= 0L) {
            queryState.appendQuery(" OFFSET ");
            queryState.appendQuery(Long.toString(this.skip));
        }
    }

    @Override
    public String getQueryString() {
        if (this.queryString == null) {
            this.generateQuery();
        }
        return this.queryString;
    }

    @Override
    public List<GeneratedQueryParameter> getQueryParameters() {
        if (this.queryParameters == null) {
            this.generateQuery();
        }
        return this.queryParameters;
    }

    @Override
    public RowReader<T> getRowReader() {
        return this.cols.reader;
    }

    @Override
    public boolean isSelectFromWhere() {
        return !this.isAggregated && this.sort.isEmpty() && this.limit < 0L && this.skip < 0L && !this.isDistinct;
    }

    @Override
    public boolean isSelectOnly() {
        return false;
    }

    @Override
    public boolean canSort() {
        return (this.getClass() == SelectFromWhere.class && !this.isAggregated || this instanceof GroupedSelectFromWhere) && this.limit < 0L && this.skip < 0L;
    }

    @Override
    public boolean canDistinct() {
        return this.isSelectFromWhere();
    }

    @Override
    public boolean isValidSubquery() {
        return this.limit < 0L && this.skip < 0L && this.sort.isEmpty();
    }

    public <U> GroupedSelectFromWhere<T, U> shallowCopyWithGrouping() {
        GroupedSelectFromWhere copy = new GroupedSelectFromWhere();
        this.copySelectFromWhereTo(copy);
        return copy;
    }

    protected void copySelectFromWhereTo(SelectFromWhere<T> copy) {
        copy.cols = this.cols;
        copy.froms.addAll(this.froms);
        copy.where = this.where;
        copy.isAggregated = this.isAggregated;
        copy.sort.addAll(this.sort);
        copy.limit = this.limit;
        copy.skip = this.skip;
        copy.isDistinct = this.isDistinct;
    }

    @Override
    public SelectFromWhere<T> shallowCopy() {
        SelectFromWhere<T> copy = new SelectFromWhere<T>();
        this.copySelectFromWhereTo(copy);
        return copy;
    }

    public static class SortingParameters {
        public Expression expr;
        public boolean isAscending;
    }
}

