/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Specification;

public interface OlapCubeQuery<TSource extends DataSource> {
    public Set<String> getDimensions();

    public Set<String> getFacts();

    public List<Map<String, Object>> analyze(List<String> var1, List<String> var2, Collection<Map.Entry<String, Boolean>> var3, Specification<TSource> var4, Integer var5, Integer var6);

    default public List<Map<String, Object>> analyze(List<String> dimensions, List<String> facts, Specification<TSource> filter) {
        return this.analyze(dimensions, facts, null, filter, null, null);
    }

    default public List<Map<String, Object>> analyze(List<String> dimensions, List<String> facts) {
        return this.analyze(dimensions, facts, null, null, null, null);
    }

    default public OlapCubeQueryBuilder<TSource> builder() {
        return new OlapCubeQueryBuilder(this);
    }

    public static class OlapCubeQueryBuilder<TSource extends DataSource> {
        private final OlapCubeQuery<TSource> query;
        private final List<String> dimensions = new ArrayList<String>();
        private final List<String> facts = new ArrayList<String>();
        private Integer resultLimit;
        private Integer resultOfset;
        private final Map<String, Boolean> order = new LinkedHashMap<String, Boolean>();

        OlapCubeQueryBuilder(OlapCubeQuery<TSource> query) {
            this.query = query;
        }

        public OlapCubeQueryBuilder<TSource> use(String dimensionOrFact) {
            if (this.query.getDimensions().contains(dimensionOrFact)) {
                this.dimensions.add(dimensionOrFact);
            } else if (this.query.getFacts().contains(dimensionOrFact)) {
                this.facts.add(dimensionOrFact);
            } else {
                throw new IllegalArgumentException("Unknown dimension or fact: " + dimensionOrFact + ". Use getDimensions or getFacts method for available dimensions and facts");
            }
            return this;
        }

        public OlapCubeQueryBuilder<TSource> ascending(String result) {
            return this.orderBy(result, true);
        }

        public OlapCubeQueryBuilder<TSource> descending(String result) {
            return this.orderBy(result, false);
        }

        private OlapCubeQueryBuilder<TSource> orderBy(String result, boolean ascending) {
            if (!this.query.getDimensions().contains(result) && !this.query.getFacts().contains(result)) {
                throw new IllegalArgumentException("Unknown result: " + result + ". Result can be only field from used dimensions and facts.");
            }
            this.order.put(result, ascending);
            return this;
        }

        public OlapCubeQueryBuilder<TSource> take(int limit) {
            return this.limit(limit);
        }

        public OlapCubeQueryBuilder<TSource> limit(int limit) {
            if (limit < 1) {
                throw new IllegalArgumentException("Invalid limit value. Limit must be positive");
            }
            this.resultLimit = limit;
            return this;
        }

        public OlapCubeQueryBuilder<TSource> skip(int offset) {
            return this.offset(offset);
        }

        public OlapCubeQueryBuilder<TSource> offset(int offset) {
            if (offset < 1) {
                throw new IllegalArgumentException("Invalid offset value. Offset must be positive");
            }
            this.resultOfset = offset;
            return this;
        }

        public List<Map<String, Object>> analyze() {
            return this.query.analyze(this.dimensions, this.facts, this.order.entrySet(), null, this.resultLimit, this.resultOfset);
        }

        public List<Map<String, Object>> analyze(Specification<TSource> specification) {
            return this.query.analyze(this.dimensions, this.facts, this.order.entrySet(), specification, this.resultLimit, this.resultOfset);
        }
    }
}

