/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.revenj.patterns.DataSource;
import org.revenj.patterns.Identifiable;
import org.revenj.patterns.OlapCubeQuery;
import org.revenj.patterns.Specification;

public interface RepositoryBulkReader {
    public void reset();

    public <T extends Identifiable> Callable<Optional<T>> find(Class<T> var1, String var2);

    public <T extends Identifiable> Callable<List<T>> find(Class<T> var1, String[] var2);

    public <T extends DataSource> Callable<List<T>> search(Class<T> var1, Specification<T> var2, Integer var3, Integer var4);

    default public <T extends DataSource> Callable<List<T>> search(Class<T> manifest, Specification<T> filter) {
        return this.search(manifest, filter, null, null);
    }

    default public <T extends DataSource> Callable<List<T>> search(Class<T> manifest) {
        return this.search(manifest, null, null, null);
    }

    default public <T extends DataSource> Callable<List<T>> search(Class<T> manifest, int limit) {
        return this.search(manifest, null, limit, null);
    }

    public <T extends DataSource> Callable<Long> count(Class<T> var1, Specification<T> var2);

    default public <T extends DataSource> Callable<Long> count(Class<T> manifest) {
        return this.count(manifest, null);
    }

    public <T extends DataSource> Callable<Boolean> exists(Class<T> var1, Specification<T> var2);

    default public <T extends DataSource> Callable<Boolean> exists(Class<T> manifest) {
        return this.exists(manifest, null);
    }

    public <TSource extends DataSource, TCube extends OlapCubeQuery<TSource>> Callable<List<Map<String, Object>>> analyze(Class<TCube> var1, List<String> var2, Collection<Map.Entry<String, Boolean>> var3, Specification<TSource> var4, Integer var5, Integer var6);

    default public <TSource extends DataSource, TCube extends OlapCubeQuery<TSource>> Callable<List<Map<String, Object>>> analyze(Class<TCube> manifest, List<String> dimensionsAndFacts, Specification<TSource> filter) {
        return this.analyze(manifest, dimensionsAndFacts, null, filter, null, null);
    }

    public void execute() throws IOException;
}

