/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.patterns;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Optional;
import org.revenj.Utils;

public interface ServiceLocator {
    public Object resolve(Type var1) throws ReflectiveOperationException;

    default public <T> Optional<T> tryResolve(Class<T> manifest) {
        try {
            Object instance = this.resolve((Type)manifest);
            return Optional.ofNullable(instance);
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }

    default public <T> T resolve(Class<T> manifest) {
        try {
            return (T)this.resolve((Type)manifest);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    default public <T> T resolve(Class<T> container, Type argument, Type ... arguments) throws ReflectiveOperationException {
        return (T)this.resolve(Utils.makeGenericType(container, argument, arguments));
    }

    default public <T> T create(Constructor<T> ctor) throws ReflectiveOperationException {
        Type[] types = ctor.getGenericParameterTypes();
        Object[] dependencies = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            dependencies[i] = this.resolve(types[i]);
        }
        return ctor.newInstance(dependencies);
    }
}

