/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.processor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"org.revenj.patterns.EventHandler", "javax.inject.Inject", "javax.inject.Singleton"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class RevenjProcessor
extends AbstractProcessor {
    private TypeElement eventTypeElement;
    private DeclaredType eventDeclaredType;
    private TypeElement injectTypeElement;
    private DeclaredType injectDeclaredType;
    private TypeElement singletonTypeElement;
    private DeclaredType singletonDeclaredType;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.eventTypeElement = processingEnv.getElementUtils().getTypeElement("org.revenj.patterns.EventHandler");
        this.eventDeclaredType = processingEnv.getTypeUtils().getDeclaredType(this.eventTypeElement, new TypeMirror[0]);
        this.injectTypeElement = processingEnv.getElementUtils().getTypeElement("javax.inject.Inject");
        this.injectDeclaredType = this.injectTypeElement != null ? processingEnv.getTypeUtils().getDeclaredType(this.injectTypeElement, new TypeMirror[0]) : null;
        this.singletonTypeElement = processingEnv.getElementUtils().getTypeElement("javax.inject.Singleton");
        this.singletonDeclaredType = this.singletonTypeElement != null ? processingEnv.getTypeUtils().getDeclaredType(this.singletonTypeElement, new TypeMirror[0]) : null;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> events = roundEnv.getElementsAnnotatedWith(this.eventTypeElement);
        Set<Object> injects = this.injectTypeElement != null ? roundEnv.getElementsAnnotatedWith(this.injectTypeElement) : new HashSet();
        Set<Object> singletons = this.singletonTypeElement != null ? roundEnv.getElementsAnnotatedWith(this.singletonTypeElement) : new HashSet();
        HashMap<String, List<String>> handlers = new HashMap<String, List<String>>();
        StringBuilder registrations = new StringBuilder();
        this.findEventHandlers(events, handlers);
        Set<TypeElement> added = this.findInjections(injects, registrations, singletons);
        this.registerTypes(singletons, added, registrations, true, this.singletonDeclaredType);
        if (!handlers.isEmpty()) {
            try {
                for (Map.Entry kv : handlers.entrySet()) {
                    FileObject rfo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + URLEncoder.encode((String)kv.getKey(), "UTF-8"), new Element[0]);
                    BufferedWriter bw = new BufferedWriter(rfo.openWriter());
                    for (String impl : (List)kv.getValue()) {
                        bw.write(impl);
                        bw.newLine();
                    }
                    bw.close();
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving event handler registrations");
            }
        }
        if (registrations.length() > 0) {
            try {
                Writer writer;
                FileObject fo = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", "revenj_container_Registrations.java");
                File file = new File(fo.toUri());
                if (file.exists()) {
                    if (!file.delete()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Failed to delete container registrations: " + file.getAbsolutePath());
                    }
                    writer = new OutputStreamWriter(new FileOutputStream(file));
                } else {
                    writer = this.processingEnv.getFiler().createSourceFile("revenj_container_Registrations", new Element[0]).openWriter();
                }
                writer.write("public class revenj_container_Registrations implements org.revenj.extensibility.SystemAspect {\n");
                writer.write("  @Override\n  public void configure(org.revenj.extensibility.Container container) {\n");
                writer.write(registrations.toString());
                writer.write("\n  }\n}");
                writer.close();
                fo = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org.revenj.extensibility.SystemAspect");
                file = new File(fo.toUri());
                if (file.exists()) {
                    List<String> content = Files.readAllLines(file.toPath());
                    if (!content.contains("revenj_container_Registrations")) {
                        Files.write(Paths.get(fo.toUri()), "revenj_container_Registrations\n".getBytes("UTF-8"), StandardOpenOption.APPEND);
                    }
                } else {
                    writer = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/org.revenj.extensibility.SystemAspect", new Element[0]).openWriter();
                    writer.write("revenj_container_Registrations\n");
                    writer.close();
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed saving container registrations");
            }
        }
        return false;
    }

    private void findEventHandlers(Set<? extends Element> events, Map<String, List<String>> handlers) {
        for (Element element : events) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement element2 = (TypeElement)element;
            if (!this.hasPublicCtor(element2)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "EventHandler requires public constructor", element2, this.getAnnotation(element2, this.eventDeclaredType));
                continue;
            }
            boolean foundImpl = false;
            for (TypeMirror typeMirror : element2.getInterfaces()) {
                String sign = typeMirror.toString();
                if (!sign.startsWith("org.revenj.patterns.DomainEventHandler<")) continue;
                List<String> impl = handlers.get(sign);
                if (impl == null) {
                    impl = new ArrayList<String>();
                    handlers.put(sign, impl);
                }
                if (element2.getNestingKind().isNested()) {
                    impl.add(element2.getEnclosingElement().asType().toString() + "$" + element2.getSimpleName().toString());
                } else {
                    impl.add(element2.asType().toString());
                }
                foundImpl = true;
            }
            if (foundImpl) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "EventHandler annotation on " + element2.toString() + " requires implementation of DomainEventHandler<T extends DomainEvent>", element2, this.getAnnotation(element2, this.eventDeclaredType));
        }
    }

    private Set<TypeElement> findInjections(Set<? extends Element> injects, StringBuilder registrations, Set<? extends Element> singletons) {
        HashSet<TypeElement> registered = new HashSet<TypeElement>();
        for (Element element : injects) {
            Element p = element.getEnclosingElement();
            if (!(element instanceof ExecutableElement) || !(p instanceof TypeElement)) continue;
            ExecutableElement element2 = (ExecutableElement)element;
            TypeElement parent = (TypeElement)p;
            if (!element2.getModifiers().contains((Object)Modifier.PUBLIC) || !parent.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "@Inject used in '" + parent.asType() + "' can only be used on a public constructor in a public type", element2, this.getAnnotation(element2, this.injectDeclaredType));
                continue;
            }
            if (parent.getTypeParameters().size() > 0) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "@Inject used on '" + parent.asType() + "' will be handled by reflection", element2, this.getAnnotation(element2, this.injectDeclaredType));
                continue;
            }
            int position = registrations.length();
            registrations.append("    container.registerFactory(");
            registrations.append(parent);
            registrations.append(".class, c -> new ");
            registrations.append(parent);
            registrations.append("(");
            for (VariableElement variableElement : element2.getParameters()) {
                String typeName = variableElement.asType().toString();
                int genInd = typeName.indexOf(60);
                String containerType = genInd > 0 ? typeName.substring(0, genInd) : typeName;
                TypeElement argType = this.processingEnv.getElementUtils().getTypeElement(containerType);
                if (!argType.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Arguments for constructor with @Inject must be public. '" + variableElement.asType() + "' is not public.", element2, this.getAnnotation(element2, this.injectDeclaredType));
                    registrations.setLength(position);
                    return registered;
                }
                if (genInd > 0) {
                    if (!this.checkGenericArguments(typeName, element2)) {
                        registrations.setLength(position);
                        return registered;
                    }
                    registrations.append("new org.revenj.patterns.Generic<");
                    registrations.append(typeName);
                    registrations.append(">(){}.resolve(c)");
                } else {
                    registrations.append("c.resolve(");
                    registrations.append(typeName);
                    registrations.append(".class)");
                }
                registrations.append(",");
            }
            if (element2.getParameters().size() > 0) {
                registrations.setLength(registrations.length() - 1);
            }
            if (singletons.contains(parent)) {
                registrations.append("), true);\n");
            } else {
                registrations.append("), false);\n");
            }
            registered.add(parent);
        }
        return registered;
    }

    private boolean checkGenericArguments(String typeName, ExecutableElement element) {
        String[] args;
        int genInd = typeName.indexOf(60);
        if (genInd == -1) {
            return true;
        }
        for (String t : args = typeName.substring(genInd + 1, typeName.length() - 1).split(",")) {
            TypeElement argType = this.processingEnv.getElementUtils().getTypeElement(t.trim());
            if (!argType.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Arguments for constructor with @Inject must be public. '" + t.trim() + "' is not public.", element, this.getAnnotation(element, this.injectDeclaredType));
                return false;
            }
            if (this.checkGenericArguments(t, element)) continue;
            return false;
        }
        return true;
    }

    private void registerTypes(Set<? extends Element> types, Set<TypeElement> injections, StringBuilder registrations, boolean singleton, DeclaredType declaredType) {
        for (Element element : types) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement element2 = (TypeElement)element;
            if (!element2.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, (singleton ? "@Singleton" : "@Transient") + " used on '" + element2.asType() + "' can only be used on a public type", element2, this.getAnnotation(element2, declaredType));
                continue;
            }
            if (injections.contains(element2)) continue;
            registrations.append("    container.register(");
            registrations.append(element2.asType());
            registrations.append(".class, ");
            registrations.append(singleton ? "true);" : "false);\n");
        }
    }

    private boolean hasPublicCtor(Element element) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return true;
        }
        return false;
    }

    private AnnotationMirror getAnnotation(Element element, DeclaredType annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }
}

