/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization.json;

import com.dslplatform.json.Configuration;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.ServiceLoader;
import org.revenj.TreePath;
import org.revenj.patterns.ServiceLocator;
import org.revenj.serialization.Serialization;
import org.revenj.serialization.json.TreePathConverter;

public class DslJsonSerialization
extends DslJson<ServiceLocator>
implements Serialization<String> {
    public DslJsonSerialization(ServiceLocator locator, Optional<DslJson.Fallback<ServiceLocator>> fallback) {
        super((Object)locator, false, true, false, (DslJson.Fallback)fallback.orElse(null), false, ServiceLoader.load(Configuration.class));
        this.registerReader(TreePath.class, TreePathConverter.Reader);
        this.registerWriter(TreePath.class, TreePathConverter.Writer);
    }

    @Override
    public String serialize(Type manifest, Object value) throws IOException {
        JsonWriter jw;
        if (value == null) {
            return "null";
        }
        if (manifest == null) {
            manifest = value.getClass();
        }
        if (!this.serialize(jw = new JsonWriter(), manifest, value)) {
            if (this.fallback != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.fallback.serialize(value, (OutputStream)os);
                return os.toString("UTF-8");
            }
            throw new IOException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
        }
        return jw.toString();
    }

    @Override
    public Object deserialize(Type type, String data) throws IOException {
        byte[] bytes = data.getBytes("UTF-8");
        return super.deserialize(type, bytes, bytes.length);
    }
}

