/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization.xml;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;

@XmlRootElement(name="dateTime")
public class TimestampXML {
    @XmlValue
    public String value;
    public static final Function<OffsetDateTime, TimestampXML> convert = s -> {
        TimestampXML xml = new TimestampXML();
        xml.value = s.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return xml;
    };

    static String create(OffsetDateTime value) {
        if (value == null) {
            return null;
        }
        return value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    static OffsetDateTime create(String value) {
        if (value == null) {
            return null;
        }
        return OffsetDateTime.parse(value);
    }

    @XmlRootElement(name="ArrayOfdateTime")
    static class ListXML {
        @XmlElement(name="dateTime")
        public List<String> value;
        public static final Function<List<OffsetDateTime>, ListXML> convert = s -> {
            ListXML xml = new ListXML();
            xml.value = new ArrayList<String>(s.size());
            for (OffsetDateTime it : s) {
                xml.value.add(TimestampXML.create(it));
            }
            return xml;
        };
        public static final Function<ListXML, List<OffsetDateTime>> parse = s -> {
            ArrayList<OffsetDateTime> result = new ArrayList<OffsetDateTime>(s.value.size());
            for (int i = 0; i < s.value.size(); ++i) {
                result.add(TimestampXML.create(s.value.get(i)));
            }
            return result;
        };

        ListXML() {
        }
    }

    @XmlRootElement(name="ArrayOfdateTime")
    static class ArrayXML {
        @XmlElement(name="dateTime")
        public String[] value;
        public static final Function<OffsetDateTime[], ArrayXML> convert = s -> {
            ArrayXML xml = new ArrayXML();
            xml.value = new String[((OffsetDateTime[])s).length];
            for (int i = 0; i < ((OffsetDateTime[])s).length; ++i) {
                xml.value[i] = TimestampXML.create(s[i]);
            }
            return xml;
        };
        public static final Function<ArrayXML, OffsetDateTime[]> parse = s -> {
            OffsetDateTime[] result = new OffsetDateTime[s.value.length];
            for (int i = 0; i < s.value.length; ++i) {
                result[i] = TimestampXML.create(s.value[i]);
            }
            return result;
        };

        ArrayXML() {
        }
    }

    public static class Adapter
    extends XmlAdapter<String, OffsetDateTime> {
        public OffsetDateTime unmarshal(String v) throws Exception {
            return TimestampXML.create(v);
        }

        public String marshal(OffsetDateTime v) throws Exception {
            return TimestampXML.create(v);
        }
    }
}

