/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.serialization.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.revenj.TreePath;

@XmlRootElement(name="TreePath")
public class TreePathXML {
    @XmlValue
    public String value;
    public static final Function<TreePath, TreePathXML> convert = s -> {
        TreePathXML xml = new TreePathXML();
        xml.value = s.toString();
        return xml;
    };

    static String create(TreePath value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    static TreePath create(String value) {
        if (value == null) {
            return null;
        }
        return TreePath.create(value);
    }

    @XmlRootElement(name="ArrayOfTreePath")
    static class ListXML {
        @XmlElement(name="TreePath")
        public List<String> value;
        public static final Function<List<TreePath>, ListXML> convert = s -> {
            ListXML xml = new ListXML();
            xml.value = new ArrayList<String>(s.size());
            for (TreePath it : s) {
                xml.value.add(TreePathXML.create(it));
            }
            return xml;
        };
        public static final Function<ListXML, List<TreePath>> parse = s -> {
            ArrayList<TreePath> result = new ArrayList<TreePath>(s.value.size());
            for (int i = 0; i < s.value.size(); ++i) {
                result.add(TreePathXML.create(s.value.get(i)));
            }
            return result;
        };

        ListXML() {
        }
    }

    @XmlRootElement(name="ArrayOfTreePath")
    static class ArrayXML {
        @XmlElement(name="TreePath")
        public String[] value;
        public static final Function<TreePath[], ArrayXML> convert = s -> {
            ArrayXML xml = new ArrayXML();
            xml.value = new String[((TreePath[])s).length];
            for (int i = 0; i < ((TreePath[])s).length; ++i) {
                xml.value[i] = TreePathXML.create(s[i]);
            }
            return xml;
        };
        public static final Function<ArrayXML, TreePath[]> parse = s -> {
            TreePath[] result = new TreePath[s.value.length];
            for (int i = 0; i < s.value.length; ++i) {
                result[i] = TreePathXML.create(s.value[i]);
            }
            return result;
        };

        ArrayXML() {
        }
    }

    public static class Adapter
    extends XmlAdapter<String, TreePath> {
        public TreePath unmarshal(String v) throws Exception {
            return TreePathXML.create(v);
        }

        public String marshal(TreePath v) throws Exception {
            return TreePathXML.create(v);
        }
    }
}

