/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.sql.DataSource;
import org.revenj.extensibility.Container;
import org.revenj.patterns.DomainEvent;
import org.revenj.patterns.DomainEventStore;

class GlobalEventStore
implements Closeable {
    private final Container container;
    private final DataSource dataSource;
    private Connection connection;
    private final ConcurrentMap<Class<?>, DomainEventStore> eventStores = new ConcurrentHashMap();
    private final BlockingQueue<DomainEvent> eventQueue = new LinkedBlockingDeque<DomainEvent>();
    private final Thread loop;
    private boolean isClosed;

    public GlobalEventStore(Container container, DataSource dataSource) {
        this.container = container;
        this.dataSource = dataSource;
        this.setupConnection();
        this.loop = new Thread(new WaitForEvents());
        this.loop.setDaemon(true);
        this.loop.start();
    }

    <TEvent extends DomainEvent> void queue(TEvent domainEvent) {
        this.eventQueue.add(domainEvent);
    }

    private void setupConnection() {
        try {
            this.eventStores.clear();
            this.connection = this.dataSource.getConnection();
            this.connection.setAutoCommit(true);
            this.container.registerInstance(this.connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        try {
            this.container.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class WaitForEvents
    implements Runnable {
        private WaitForEvents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Object> bulk = new ArrayList<Object>(1000);
            Object info = null;
            while (!GlobalEventStore.this.isClosed) {
                try {
                    if (bulk.size() == 0) {
                        info = (DomainEvent)GlobalEventStore.this.eventQueue.take();
                        bulk.add(info);
                    }
                    if (info == null) break;
                    Class<?> lastType = info.getClass();
                    int i = 0;
                    while (i++ < 1000 && !GlobalEventStore.this.eventQueue.isEmpty() && (info = (DomainEvent)GlobalEventStore.this.eventQueue.take()).getClass() == lastType) {
                        bulk.add(info);
                    }
                    Class<?> currentType = lastType;
                    DomainEventStore store = GlobalEventStore.this.eventStores.computeIfAbsent(lastType, t -> {
                        try {
                            return GlobalEventStore.this.container.resolve(DomainEventStore.class, currentType, new Type[0]);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    try {
                        store.submit(bulk);
                    }
                    finally {
                        bulk.clear();
                    }
                    if (info.getClass() == currentType) continue;
                    bulk.add(info);
                }
                catch (Exception e) {
                    try {
                        GlobalEventStore.this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GlobalEventStore.this.setupConnection();
                }
            }
        }
    }
}

