/*
 * Decompiled with CFR 0.152.
 */
package org.revenj;

import org.revenj.extensibility.Container;
import org.revenj.extensibility.SystemState;
import rx.Observable;
import rx.subjects.PublishSubject;

class RevenjSystemState
implements SystemState {
    private boolean systemBooting = true;
    private boolean systemReady = false;
    private final PublishSubject<SystemState.SystemEvent> changeSubject = PublishSubject.create();
    private final PublishSubject<Container> startupSubject = PublishSubject.create();
    private final Observable<SystemState.SystemEvent> changeEvents = this.changeSubject.asObservable();
    private final Observable<Container> startupEvents = this.startupSubject.asObservable();

    @Override
    public boolean isBooting() {
        return this.systemBooting;
    }

    @Override
    public boolean isReady() {
        return this.systemReady;
    }

    void started(Container container) {
        this.systemBooting = false;
        this.systemReady = true;
        this.startupSubject.onNext((Object)container);
    }

    @Override
    public Observable<Container> ready() {
        return this.startupEvents;
    }

    @Override
    public Observable<SystemState.SystemEvent> change() {
        return this.changeEvents;
    }

    @Override
    public void notify(SystemState.SystemEvent value) {
        this.changeSubject.onNext((Object)value);
    }
}

