/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.net.SocketFactory;
import org.postgresql.PGProperty;
import org.postgresql.core.Encoding;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.v2.SocketFactoryFactory;
import org.postgresql.gss.MakeGSS;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.sspi.ISSPIClient;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;

    private static ISSPIClient createSSPI(PGStream pgStream, String spnServiceClass, boolean enableNegotiate, Logger logger) {
        try {
            Class<?> c = Class.forName("org.postgresql.sspi.SSPIClient");
            Class[] cArg = new Class[]{PGStream.class, String.class, Boolean.TYPE, Logger.class};
            return (ISSPIClient)c.getDeclaredConstructor(cArg).newInstance(pgStream, spnServiceClass, enableNegotiate, logger);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to load org.postgresql.sspi.SSPIClient. Please check that SSPIClient is included in your pgjdbc distribution.", e);
        }
    }

    public static PGStream openConnection(HostSpec hostSpec, String user, String password, String database, Properties info) throws SQLException {
        boolean requireSSL;
        boolean trySSL;
        Logger logger = new Logger();
        String sslmode = PGProperty.SSL_MODE.get(info);
        if (sslmode == null) {
            trySSL = PGProperty.SSL.getBoolean(info) || "".equals(PGProperty.SSL.get(info));
            requireSSL = trySSL;
        } else if ("disable".equals(sslmode)) {
            trySSL = false;
            requireSSL = false;
        } else if ("require".equals(sslmode) || "verify-ca".equals(sslmode) || "verify-full".equals(sslmode)) {
            trySSL = true;
            requireSSL = true;
        } else {
            throw new PSQLException(GT.tr((String)"Invalid sslmode value: {0}", (Object)sslmode), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        int connectTimeout = PGProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory((Properties)info);
        PGStream newStream = null;
        try {
            int sendBufferSize;
            int socketTimeout;
            newStream = new PGStream(socketFactory, hostSpec, connectTimeout);
            if (trySSL) {
                newStream = ConnectionFactory.enableSSL(newStream, requireSSL, info, logger, connectTimeout);
            }
            if ((socketTimeout = PGProperty.SOCKET_TIMEOUT.getInt(info)) > 0) {
                newStream.getSocket().setSoTimeout(socketTimeout * 1000);
            }
            newStream.getSocket().setKeepAlive(true);
            int receiveBufferSize = PGProperty.RECEIVE_BUFFER_SIZE.getInt(info);
            if (receiveBufferSize > -1 && receiveBufferSize > 0) {
                newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
            }
            if ((sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(info)) > -1 && sendBufferSize > 0) {
                newStream.getSocket().setSendBufferSize(sendBufferSize);
            }
            ArrayList<String[]> paramList = new ArrayList<String[]>();
            paramList.add(new String[]{"user", user});
            paramList.add(new String[]{"database", database});
            paramList.add(new String[]{"client_encoding", "UTF8"});
            paramList.add(new String[]{"DateStyle", "ISO"});
            paramList.add(new String[]{"TimeZone", ConnectionFactory.createPostgresTimeZone()});
            String assumeMinServerVersion = PGProperty.ASSUME_MIN_SERVER_VERSION.get(info);
            paramList.add(new String[]{"extra_float_digits", "3"});
            String appName = PGProperty.APPLICATION_NAME.get(info);
            paramList.add(new String[]{"application_name", appName == null ? "Revenj" : appName});
            String currentSchema = PGProperty.CURRENT_SCHEMA.get(info);
            if (currentSchema != null) {
                paramList.add(new String[]{"search_path", currentSchema});
            }
            ConnectionFactory.sendStartupPacket(newStream, paramList, logger);
            ConnectionFactory.doAuthentication(newStream, hostSpec.getHost(), user, password, info, logger);
            ConnectionFactory.readStartupMessages(newStream, logger);
            return newStream;
        }
        catch (UnsupportedProtocolException upe) {
            ConnectionFactory.closeStream(newStream);
            throw new PSQLException(GT.tr((String)"Unsupported protocol"), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)upe);
        }
        catch (ConnectException cex) {
            throw new PSQLException(GT.tr((String)"Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", (Object)hostSpec), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
        }
        catch (IOException ioe) {
            ConnectionFactory.closeStream(newStream);
            throw new PSQLException(GT.tr((String)"The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            ConnectionFactory.closeStream(newStream);
            throw se;
        }
    }

    private static void closeStream(PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        if (sign == '+') {
            start = "GMT-";
        } else if (sign == '-') {
            start = "GMT+";
        } else {
            return tz;
        }
        return start + tz.substring(4);
    }

    private static PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info, Logger logger, int connectTimeout) throws IOException, SQLException {
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (requireSSL) {
                    throw new PSQLException(GT.tr((String)"The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout);
            }
            case 78: {
                if (requireSSL) {
                    throw new PSQLException(GT.tr((String)"The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                MakeSSL.convert((PGStream)pgStream, (Properties)info, (Logger)logger);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr((String)"An error occurred while setting up the SSL connection."), PSQLState.PROTOCOL_VIOLATION);
    }

    private static void sendStartupPacket(PGStream pgStream, List<String[]> params, Logger logger) throws IOException {
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.SendInteger4(++length);
        pgStream.SendInteger2(3);
        pgStream.SendInteger2(0);
        for (byte[] encodedParam : encodedParams) {
            pgStream.Send(encodedParam);
            pgStream.SendChar(0);
        }
        pgStream.SendChar(0);
        pgStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAuthentication(PGStream pgStream, String host, String user, String password, Properties info, Logger logger) throws IOException, SQLException {
        block33: {
            ISSPIClient sspiClient = null;
            try {
                while (true) {
                    int beresp = pgStream.ReceiveChar();
                    block3 : switch (beresp) {
                        case 69: {
                            int l_elen = pgStream.ReceiveInteger4();
                            if (l_elen > 30000) {
                                throw new UnsupportedProtocolException();
                            }
                            ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger.getLogLevel());
                            throw new PSQLException(errorMsg);
                        }
                        case 82: {
                            int l_msgLen = pgStream.ReceiveInteger4();
                            int areq = pgStream.ReceiveInteger4();
                            switch (areq) {
                                case 4: {
                                    byte[] salt = pgStream.Receive(2);
                                    if (password == null) {
                                        throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] encodedResult = UnixCrypt.crypt((byte[])salt, (byte[])password.getBytes("UTF-8"));
                                    pgStream.SendChar(112);
                                    pgStream.SendInteger4(4 + encodedResult.length + 1);
                                    pgStream.Send(encodedResult);
                                    pgStream.SendChar(0);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 5: {
                                    byte[] md5Salt = pgStream.Receive(4);
                                    if (password == null) {
                                        throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] digest = MD5Digest.encode((byte[])user.getBytes("UTF-8"), (byte[])password.getBytes("UTF-8"), (byte[])md5Salt);
                                    pgStream.SendChar(112);
                                    pgStream.SendInteger4(4 + digest.length + 1);
                                    pgStream.Send(digest);
                                    pgStream.SendChar(0);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 3: {
                                    if (logger.logDebug()) {
                                        logger.debug(" <=BE AuthenticationReqPassword");
                                        logger.debug(" FE=> Password(password=<not shown>)");
                                    }
                                    if (password == null) {
                                        throw new PSQLException(GT.tr((String)"The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                                    }
                                    byte[] encodedPassword = password.getBytes("UTF-8");
                                    pgStream.SendChar(112);
                                    pgStream.SendInteger4(4 + encodedPassword.length + 1);
                                    pgStream.Send(encodedPassword);
                                    pgStream.SendChar(0);
                                    pgStream.flush();
                                    break block3;
                                }
                                case 7: 
                                case 9: {
                                    String gsslib = PGProperty.GSS_LIB.get(info);
                                    boolean usespnego = PGProperty.USE_SPNEGO.getBoolean(info);
                                    boolean useSSPI = false;
                                    if (gsslib.equals("gssapi")) {
                                        logger.debug("Using JSSE GSSAPI, param gsslib=gssapi");
                                    } else if (areq == 7 && !gsslib.equals("sspi")) {
                                        logger.debug("Using JSSE GSSAPI, gssapi requested by server and gsslib=sspi not forced");
                                    } else {
                                        sspiClient = ConnectionFactory.createSSPI(pgStream, PGProperty.SSPI_SERVICE_CLASS.get(info), areq == 9 || areq == 7 && usespnego, logger);
                                        useSSPI = sspiClient.isSSPISupported();
                                        if (!useSSPI) {
                                            sspiClient = null;
                                            if (gsslib.equals("sspi")) {
                                                throw new PSQLException("SSPI forced with gsslib=sspi, but SSPI not available; set loglevel=2 for details", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                                            }
                                        }
                                    }
                                    if (useSSPI) {
                                        sspiClient.startSSPI();
                                        break block3;
                                    }
                                    MakeGSS.authenticate((PGStream)pgStream, (String)host, (String)user, (String)password, (String)PGProperty.JAAS_APPLICATION_NAME.get(info), (String)PGProperty.KERBEROS_SERVER_NAME.get(info), (Logger)logger, (boolean)usespnego);
                                    break block3;
                                }
                                case 8: {
                                    sspiClient.continueSSPI(l_msgLen - 8);
                                    break block3;
                                }
                                case 0: {
                                    break block33;
                                }
                                default: {
                                    throw new PSQLException(GT.tr((String)"The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", (Object)areq), PSQLState.CONNECTION_REJECTED);
                                }
                            }
                        }
                        default: {
                            throw new PSQLException(GT.tr((String)"Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                        }
                    }
                }
            }
            finally {
                if (sspiClient != null) {
                    try {
                        sspiClient.dispose();
                    }
                    catch (RuntimeException ex) {
                        logger.log("Unexpected error during SSPI context disposal", (Throwable)ex);
                    }
                }
            }
        }
    }

    private static void readStartupMessages(PGStream pgStream, Logger logger) throws IOException, SQLException {
        block7: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (pgStream.ReceiveInteger4() != 5) {
                        throw new IOException("unexpected length of ReadyForQuery packet");
                    }
                    pgStream.ReceiveChar();
                    return;
                }
                case 75: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    if (l_msgLen != 12) {
                        throw new PSQLException(GT.tr((String)"Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                    }
                    pgStream.ReceiveInteger4();
                    pgStream.ReceiveInteger4();
                    continue block7;
                }
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger.getLogLevel());
                    throw new PSQLException(l_errorMsg);
                }
                case 78: {
                    int l_nlen = pgStream.ReceiveInteger4();
                    pgStream.ReceiveString(l_nlen - 4);
                    continue block7;
                }
                case 83: {
                    pgStream.ReceiveInteger4();
                    String name = pgStream.ReceiveString();
                    String value = pgStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (!name.equals("client_encoding")) continue block7;
                    if (!value.equals("UTF8")) {
                        throw new PSQLException(GT.tr((String)"Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                    }
                    pgStream.setEncoding(Encoding.getDatabaseEncoding((String)"UTF8"));
                    continue block7;
                }
            }
            break;
        }
        throw new PSQLException(GT.tr((String)"Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private static class UnsupportedProtocolException
    extends IOException {
        private UnsupportedProtocolException() {
        }
    }
}

