/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.patterns.ServiceLocator;

public final class PostgresReader
implements PostgresBuffer,
AutoCloseable {
    private String input = "";
    private int length;
    private int positionInInput;
    private int last;
    private char[] buffer = new char[64];
    private int positionInBuffer;
    private ServiceLocator locator;
    public final char[] tmp = new char[48];
    private static ThreadLocal<PostgresReader> threadReader = new ThreadLocal<PostgresReader>(){

        @Override
        protected PostgresReader initialValue() {
            return new PostgresReader();
        }
    };

    public PostgresReader() {
        this(null);
    }

    public PostgresReader(ServiceLocator locator) {
        this.locator = locator;
    }

    public Optional<ServiceLocator> getLocator() {
        return Optional.ofNullable(this.locator);
    }

    void reset(ServiceLocator locator) {
        this.positionInBuffer = 0;
        this.positionInInput = 0;
        this.locator = locator;
    }

    public static PostgresReader create(ServiceLocator locator) {
        PostgresReader reader = threadReader.get();
        reader.reset(locator);
        return reader;
    }

    @Override
    public void close() {
        this.positionInInput = 0;
        this.positionInBuffer = 0;
        this.length = 0;
        this.last = -1;
    }

    public void process(String input) {
        this.input = input;
        this.length = input.length();
        this.positionInInput = 0;
        this.positionInBuffer = 0;
        this.last = 0;
    }

    public int read() {
        if (this.positionInInput >= this.length) {
            this.last = -1;
            return -1;
        }
        char c = this.input.charAt(this.positionInInput++);
        this.last = c;
        return c;
    }

    public int read(int total) {
        if (total == 0) {
            return 0;
        }
        if (total > 1) {
            this.positionInInput += total - 1;
        }
        return this.read();
    }

    public int peek() {
        if (this.positionInInput >= this.length) {
            return -1;
        }
        return this.input.charAt(this.positionInInput);
    }

    public int last() {
        return this.last;
    }

    @Override
    public char[] getTempBuffer() {
        return this.tmp;
    }

    @Override
    public void initBuffer() {
        this.positionInBuffer = 0;
    }

    @Override
    public void initBuffer(char c) {
        this.positionInBuffer = 1;
        this.buffer[0] = c;
    }

    @Override
    public void addToBuffer(char c) {
        if (this.positionInBuffer == this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
        }
        this.buffer[this.positionInBuffer++] = c;
    }

    @Override
    public void addToBuffer(char[] buf) {
        if (this.positionInBuffer + buf.length >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + buf.length);
        }
        for (int i = 0; i < buf.length; ++i) {
            this.buffer[this.positionInBuffer + i] = buf[i];
        }
        this.positionInBuffer += buf.length;
    }

    @Override
    public void addToBuffer(char[] buf, int len) {
        if (this.positionInBuffer + len >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + len);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.positionInBuffer + i] = buf[i];
        }
        this.positionInBuffer += len;
    }

    @Override
    public void addToBuffer(char[] buf, int offset, int end) {
        if (this.positionInBuffer + end >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + end);
        }
        for (int i = offset; i < end; ++i) {
            this.buffer[this.positionInBuffer + i - offset] = buf[i];
        }
        this.positionInBuffer += end - offset;
    }

    @Override
    public void addToBuffer(String input) {
        int len = input.length();
        if (this.positionInBuffer + len >= this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2 + len);
        }
        input.getChars(0, len, this.buffer, this.positionInBuffer);
        this.positionInBuffer += len;
    }

    public void fillUntil(char c1, char c2) throws IOException {
        char c;
        int i;
        for (i = this.positionInInput; i < this.input.length() && (c = this.input.charAt(i)) != c1 && c != c2; ++i) {
            this.addToBuffer(c);
        }
        this.positionInInput = i;
        if (this.positionInInput == this.input.length()) {
            throw new IOException("End of input detected");
        }
    }

    public int fillUntil(char[] target, int offset, char c1, char c2) throws IOException {
        char c;
        int i;
        int start = offset;
        for (i = this.positionInInput; i < this.input.length() && (c = this.input.charAt(i)) != c1 && c != c2; ++i) {
            target[offset++] = c;
        }
        this.positionInInput = i;
        if (this.positionInInput == this.input.length()) {
            throw new IOException("End of input detected");
        }
        return offset - start;
    }

    public void fillTotal(char[] target, int offset, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            target[i + offset] = this.input.charAt(this.positionInInput + i);
        }
        this.positionInInput += count;
    }

    @Override
    public String bufferToString() {
        int len = this.positionInBuffer;
        this.positionInBuffer = 0;
        if (len == 0) {
            return "";
        }
        return new String(this.buffer, 0, len);
    }

    public <T> T bufferToValue(ConvertToValue<T> converter) {
        return converter.to(this.buffer, 0, this.positionInBuffer);
    }

    public boolean bufferMatches(String compare) {
        if (compare.length() != this.positionInBuffer) {
            return false;
        }
        for (int i = 0; i < compare.length(); ++i) {
            if (this.buffer[i] == compare.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int bufferHash() {
        int len = this.positionInBuffer;
        long hash = -2128831035L;
        for (int i = 0; i < len && i < this.buffer.length; ++i) {
            hash = (hash ^ (long)this.buffer[i]) * 16777619L;
        }
        return (int)hash;
    }

    private static int findEscapedChar(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '\\' && c != '/') continue;
            return i;
        }
        return -1;
    }

    public static void parseCompositeURI(String uri, String[] result) throws IOException {
        int index = 0;
        int i = PostgresReader.findEscapedChar(uri);
        if (i == -1) {
            result[0] = uri;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(uri, 0, i);
            while (i < uri.length()) {
                char c = uri.charAt(i);
                if (c == '\\') {
                    sb.append(uri.charAt(++i));
                } else if (c == '/') {
                    result[index++] = sb.toString();
                    if (index == result.length) {
                        throw new IOException("Invalid URI provided: " + uri + ". Number of expected parts: " + result.length);
                    }
                    sb.setLength(0);
                } else {
                    sb.append(c);
                }
                ++i;
            }
            sb.append(uri, i, uri.length());
            result[index] = sb.toString();
        }
    }

    public static interface ConvertToValue<T> {
        public T to(char[] var1, int var2, int var3);
    }
}

