/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public class ArrayTuple
extends PostgresTuple {
    public static final PostgresTuple EMPTY = new EmptyArrayTuple();
    public static final PostgresTuple NULL = new NullTuple();
    private final PostgresTuple[] elements;
    private final boolean escapeRecord;

    private ArrayTuple(PostgresTuple[] elements) {
        this.elements = elements;
        this.escapeRecord = elements.length > 1 || elements[0] != null && elements[0].mustEscapeRecord();
    }

    public static PostgresTuple from(PostgresTuple[] elements) {
        if (elements == null) {
            return NULL;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        return new ArrayTuple(elements);
    }

    @Override
    public boolean mustEscapeRecord() {
        return this.escapeRecord;
    }

    @Override
    public boolean mustEscapeArray() {
        return true;
    }

    public static PostgresTuple create(double[] elements, Function<Double, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            tuples[i] = converter.apply(elements[i]);
        }
        return new ArrayTuple(tuples);
    }

    public static PostgresTuple create(int[] elements, Function<Integer, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            tuples[i] = converter.apply(elements[i]);
        }
        return new ArrayTuple(tuples);
    }

    public static PostgresTuple create(long[] elements, Function<Long, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            tuples[i] = converter.apply(elements[i]);
        }
        return new ArrayTuple(tuples);
    }

    public static PostgresTuple create(float[] elements, Function<Float, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            tuples[i] = converter.apply(Float.valueOf(elements[i]));
        }
        return new ArrayTuple(tuples);
    }

    public static PostgresTuple create(boolean[] elements, Function<Boolean, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            tuples[i] = converter.apply(elements[i]);
        }
        return new ArrayTuple(tuples);
    }

    public static <T> PostgresTuple create(T[] elements, Function<T, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.length == 0) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            tuples[i] = converter.apply(elements[i]);
        }
        return new ArrayTuple(tuples);
    }

    public static <T> PostgresTuple create(List<T> elements, Function<T, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.isEmpty()) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            tuples[i] = converter.apply(elements.get(i));
        }
        return new ArrayTuple(tuples);
    }

    public static <T> PostgresTuple create(Collection<T> elements, Function<T, PostgresTuple> converter) {
        if (elements == null) {
            return null;
        }
        if (elements.isEmpty()) {
            return EMPTY;
        }
        PostgresTuple[] tuples = new PostgresTuple[elements.size()];
        int i = 0;
        for (T t : elements) {
            tuples[i++] = converter.apply(t);
        }
        return new ArrayTuple(tuples);
    }

    public static <T> List<T> parse(PostgresReader reader, int context, RecordParser<T> converter) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>();
        int arrayContext = Math.max(context << 1, 1);
        int recordContext = arrayContext << 1;
        while (cur != -1 && cur != 125) {
            boolean innerEscaped;
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                list.add(null);
                continue;
            }
            boolean bl2 = innerEscaped = cur != 40;
            if (innerEscaped) {
                reader.read(arrayContext);
            }
            list.add(converter.parse(reader, 0, recordContext));
            if (innerEscaped) {
                cur = reader.read(arrayContext + 1);
                continue;
            }
            cur = reader.read();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    @Override
    public void buildTuple(PostgresWriter sw, boolean quote) {
        PostgresTuple.Mapping mappings = null;
        if (quote) {
            mappings = PostgresTuple::escapeQuote;
            sw.write('\'');
        }
        sw.write('{');
        PostgresTuple e = this.elements[0];
        if (e != null) {
            if (e.mustEscapeArray()) {
                sw.write('\"');
                e.insertArray(sw, "0", mappings);
                sw.write('\"');
            } else {
                e.insertArray(sw, "", mappings);
            }
        } else {
            sw.write("NULL");
        }
        for (int i = 1; i < this.elements.length; ++i) {
            sw.write(',');
            e = this.elements[i];
            if (e != null) {
                if (e.mustEscapeArray()) {
                    sw.write('\"');
                    e.insertArray(sw, "0", mappings);
                    sw.write('\"');
                    continue;
                }
                e.insertArray(sw, "", mappings);
                continue;
            }
            sw.write("NULL");
        }
        sw.write('}');
        if (quote) {
            sw.write('\'');
        }
    }

    @Override
    public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        sw.write('{');
        String newEscaping = escaping + "0";
        String quote = null;
        PostgresTuple e = this.elements[0];
        if (e != null) {
            if (e.mustEscapeArray()) {
                int x;
                quote = ArrayTuple.buildQuoteEscape(escaping);
                if (mappings != null) {
                    for (x = 0; x < quote.length(); ++x) {
                        mappings.map(sw, quote.charAt(x));
                    }
                } else {
                    sw.write(quote);
                }
                e.insertArray(sw, newEscaping, mappings);
                if (mappings != null) {
                    for (x = 0; x < quote.length(); ++x) {
                        mappings.map(sw, quote.charAt(x));
                    }
                } else {
                    sw.write(quote);
                }
            } else {
                e.insertArray(sw, escaping, mappings);
            }
        } else {
            sw.write("NULL");
        }
        for (int i = 1; i < this.elements.length; ++i) {
            sw.write(',');
            e = this.elements[i];
            if (e != null) {
                if (e.mustEscapeArray()) {
                    int x;
                    String string = quote = quote != null ? quote : ArrayTuple.buildQuoteEscape(escaping);
                    if (mappings != null) {
                        for (x = 0; x < quote.length(); ++x) {
                            mappings.map(sw, quote.charAt(x));
                        }
                    } else {
                        sw.write(quote);
                    }
                    e.insertArray(sw, newEscaping, mappings);
                    if (mappings != null) {
                        for (x = 0; x < quote.length(); ++x) {
                            mappings.map(sw, quote.charAt(x));
                        }
                        continue;
                    }
                    sw.write(quote);
                    continue;
                }
                e.insertArray(sw, escaping, mappings);
                continue;
            }
            sw.write("NULL");
        }
        sw.write('}');
    }

    @Override
    public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        throw new RuntimeException("Should not happen. Insert array called on array tuple. Nested arrays are invalid construct.");
    }

    public static interface RecordParser<T> {
        public T parse(PostgresReader var1, int var2, int var3) throws IOException;
    }

    private static class NullTuple
    extends PostgresTuple {
        private NullTuple() {
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write("NULL");
        }

        @Override
        public String buildTuple(boolean quote) {
            return "NULL";
        }
    }

    private static class EmptyArrayTuple
    extends PostgresTuple {
        private EmptyArrayTuple() {
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write("{}");
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            throw new RuntimeException("Should not happen. Insert array called on array tuple. Nested arrays are invalid construct.");
        }

        @Override
        public String buildTuple(boolean quote) {
            return quote ? "'{}'" : "{}";
        }
    }
}

