/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public abstract class ByteaConverter {
    private static final char[] CharMap = "0123456789abcdef".toCharArray();
    private static final int[] CharLookup = new int[103];
    private static final byte[] EMPTY_BYTES;
    private static final char[] XX;

    public static void serializeURI(PostgresBuffer sw, byte[] value) {
        sw.addToBuffer(XX);
        for (byte b : value) {
            sw.addToBuffer(CharMap[b >> 4 & 0xF]);
            sw.addToBuffer(CharMap[b & 0xF]);
        }
    }

    private static byte[] toArray(List<Byte> list) {
        byte[] result = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static byte[] parse(PostgresReader reader, int context) {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        int len = context + (context << 1);
        if (len == 0) {
            len = 1;
        }
        cur = reader.read(len + 1);
        ArrayList<Byte> list = new ArrayList<Byte>(1024);
        while (cur != -1 && cur != 92 && cur != 34) {
            list.add((byte)((CharLookup[cur] << 4) + CharLookup[reader.read()]));
            cur = reader.read();
        }
        reader.read(context);
        return ByteaConverter.toArray(list);
    }

    public static List<byte[]> parseCollection(PostgresReader reader, int context, boolean allowNulls) {
        byte[] emptyColl;
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        int innerContext = context << 1;
        int skipInner = innerContext + (innerContext << 1);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        cur = reader.peek();
        if (cur == 125) {
            reader.read();
        }
        byte[] byArray = emptyColl = allowNulls ? null : EMPTY_BYTES;
        while (cur != -1 && cur != 125) {
            cur = reader.read();
            if (cur == 78) {
                list.add(emptyColl);
                cur = reader.read(4);
                continue;
            }
            reader.read(skipInner);
            ArrayList<Byte> item = new ArrayList<Byte>(1024);
            cur = reader.read();
            while (cur != -1 && cur != 34 && cur != 92) {
                item.add((byte)((CharLookup[cur] << 4) + CharLookup[reader.read()]));
                cur = reader.read();
            }
            cur = reader.read(innerContext);
            list.add(ByteaConverter.toArray(item));
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(byte[] value) {
        return value != null ? new ByteTuple(value) : null;
    }

    static {
        for (int i = 0; i < CharMap.length; ++i) {
            ByteaConverter.CharLookup[ByteaConverter.CharMap[i]] = i;
        }
        EMPTY_BYTES = new byte[0];
        XX = "\\x".toCharArray();
    }

    private static class ByteTuple
    extends PostgresTuple {
        private final byte[] value;

        ByteTuple(byte[] value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return true;
        }

        private void buildArray(PostgresWriter sw) {
            for (byte b : this.value) {
                sw.write(CharMap[b >> 4 & 0xF]);
                sw.write(CharMap[b & 0xF]);
            }
        }

        @Override
        public void buildTuple(PostgresWriter sw, boolean quote) {
            if (quote) {
                sw.write('\'');
                this.insertRecord(sw, "", null);
                sw.write('\'');
            } else {
                this.insertRecord(sw, "", null);
            }
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            String pref = ByteTuple.buildSlashEscape(escaping.length());
            if (mappings != null) {
                for (int x = 0; x < pref.length(); ++x) {
                    mappings.map(sw, pref.charAt(x));
                }
            } else {
                sw.write(pref);
            }
            sw.write('x');
            this.buildArray(sw);
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            this.insertRecord(sw, escaping, mappings);
        }
    }
}

