/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public abstract class DoubleConverter {
    public static void serializeURI(PostgresBuffer sw, double value) throws IOException {
        sw.addToBuffer(Double.toString(value));
    }

    public static void serializeURI(PostgresWriter sw, Double value) throws IOException {
        if (value == null) {
            return;
        }
        sw.write(value.toString());
    }

    public static Double parseNullable(PostgresReader reader) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        double value = DoubleConverter.parseDouble(reader, cur, ')');
        reader.read();
        return value;
    }

    public static double parse(PostgresReader reader) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return 0.0;
        }
        double value = DoubleConverter.parseDouble(reader, cur, ')');
        reader.read();
        return value;
    }

    private static double parseDouble(PostgresReader reader, int cur, char matchEnd) throws IOException {
        reader.initBuffer((char)cur);
        reader.fillUntil(',', matchEnd);
        return Double.parseDouble(reader.bufferToString());
    }

    public static List<Double> parseCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Double>(0);
        }
        Double defaultValue = allowNulls ? null : Double.valueOf(0.0);
        ArrayList<Double> list = new ArrayList<Double>();
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read();
                if (cur == 85) {
                    cur = reader.read(3);
                    list.add(defaultValue);
                    continue;
                }
                list.add(Double.NaN);
                cur = reader.read(2);
                continue;
            }
            list.add(DoubleConverter.parseDouble(reader, cur, '}'));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(double value) {
        return new DoubleTuple(value);
    }

    public static PostgresTuple toTuple(Double value) {
        return value == null ? null : new DoubleTuple(value);
    }

    private static class DoubleTuple
    extends PostgresTuple {
        private final double value;

        DoubleTuple(double value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(Double.toString(this.value));
        }

        @Override
        public String buildTuple(boolean quote) {
            return Double.toString(this.value);
        }
    }
}

