/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public abstract class EnumConverter {
    public static void serializeURI(PostgresBuffer sw, Enum value) {
        if (value == null) {
            return;
        }
        sw.addToBuffer(value.name());
    }

    public static <T extends Enum> List<T> parseCollection(PostgresReader reader, int context, T defaultValue, Function<PostgresReader, T> factory) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context);
            } else {
                reader.read(2);
            }
            return new ArrayList(0);
        }
        int innerContext = context == 0 ? 1 : context << 1;
        ArrayList<T> list = new ArrayList<T>();
        do {
            if ((cur = reader.read()) == 34 || cur == 92) {
                cur = reader.read(innerContext);
                reader.initBuffer((char)cur);
                reader.fillUntil('\\', '\"');
                list.add(factory.apply(reader));
                cur = reader.read(innerContext + 1);
                continue;
            }
            reader.initBuffer((char)cur);
            reader.fillUntil(',', '}');
            cur = reader.read();
            if (reader.bufferMatches("NULL")) {
                list.add(defaultValue);
                continue;
            }
            list.add(factory.apply(reader));
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static <T extends Enum> PostgresTuple toTuple(T value) {
        if (value == null) {
            return null;
        }
        return new EnumTuple(value.name());
    }

    private static class EnumTuple
    extends PostgresTuple {
        private final String value;
        private final boolean escapeArray;

        EnumTuple(String value) {
            this.value = value;
            this.escapeArray = "NULL".equals(value);
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return this.escapeArray;
        }

        @Override
        public String buildTuple(boolean quote) {
            return quote ? "'" + this.value + "'" : this.value;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(this.value);
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            if (mappings != null) {
                for (int x = 0; x < this.value.length(); ++x) {
                    mappings.map(sw, this.value.charAt(x));
                }
            } else {
                sw.write(this.value);
            }
        }
    }
}

