/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;

public abstract class FloatConverter {
    public static void serializeURI(PostgresBuffer sw, float value) throws IOException {
        sw.addToBuffer(Float.toString(value));
    }

    public static void serializeURI(PostgresBuffer sw, Float value) throws IOException {
        if (value == null) {
            return;
        }
        sw.addToBuffer(Float.toString(value.floatValue()));
    }

    public static Float parseNullable(PostgresReader reader) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        float value = FloatConverter.parseFloat(reader, cur, ')');
        reader.read();
        return Float.valueOf(value);
    }

    public static float parse(PostgresReader reader) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return 0.0f;
        }
        float value = FloatConverter.parseFloat(reader, cur, ')');
        reader.read();
        return value;
    }

    private static float parseFloat(PostgresReader reader, int cur, char matchEnd) throws IOException {
        reader.initBuffer((char)cur);
        reader.fillUntil(',', matchEnd);
        return Float.parseFloat(reader.bufferToString());
    }

    public static List<Float> parseCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        if ((cur = reader.peek()) == 125) {
            if (escaped) {
                reader.read(context + 2);
            } else {
                reader.read(2);
            }
            return new ArrayList<Float>(0);
        }
        Float defaultValue = allowNulls ? null : Float.valueOf(0.0f);
        ArrayList<Float> list = new ArrayList<Float>();
        do {
            if ((cur = reader.read()) == 78) {
                cur = reader.read();
                if (cur == 85) {
                    cur = reader.read(3);
                    list.add(defaultValue);
                    continue;
                }
                list.add(Float.valueOf(Float.NaN));
                cur = reader.read(2);
                continue;
            }
            list.add(Float.valueOf(FloatConverter.parseFloat(reader, cur, '}')));
            cur = reader.read();
        } while (cur == 44);
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(float value) {
        return new FloatTuple(value);
    }

    public static PostgresTuple toTuple(Float value) {
        return value == null ? null : new FloatTuple(value.floatValue());
    }

    private static class FloatTuple
    extends PostgresTuple {
        private final float value;

        FloatTuple(float value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return false;
        }

        @Override
        public boolean mustEscapeArray() {
            return false;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            sw.write(Float.toString(this.value));
        }

        @Override
        public String buildTuple(boolean quote) {
            return Float.toString(this.value);
        }
    }
}

