/*
 * Decompiled with CFR 0.152.
 */
package org.revenj.database.postgres.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.revenj.database.postgres.PostgresBuffer;
import org.revenj.database.postgres.PostgresReader;
import org.revenj.database.postgres.PostgresWriter;
import org.revenj.database.postgres.converters.PostgresTuple;
import org.revenj.database.postgres.converters.StringConverter;

public abstract class HstoreConverter {
    private static String toDatabase(Map<String, String> value) {
        if (value.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> kv : value.entrySet()) {
            sb.append('\"');
            sb.append(kv.getKey().replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append("\"=>");
            if (kv.getValue() == null) {
                sb.append("NULL, ");
                continue;
            }
            sb.append('\"');
            sb.append(kv.getValue().replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append("\", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public static void serializeURI(PostgresBuffer sw, Map<String, String> value) {
        if (value == null) {
            return;
        }
        sw.addToBuffer(HstoreConverter.toDatabase(value));
    }

    public static void serializeCompositeURI(PostgresBuffer sw, Map<String, String> value) {
        if (value == null) {
            return;
        }
        String str = HstoreConverter.toDatabase(value);
        StringConverter.serializeCompositeURI(sw, str);
    }

    public static Map<String, String> parse(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return allowNulls ? null : new HashMap(0);
        }
        return HstoreConverter.parseMap(reader, context, context > 0 ? context << 1 : 1, ')');
    }

    private static Map<String, String> parseMap(PostgresReader reader, int context, int quoteContext, char matchEnd) throws IOException {
        int i;
        int cur = reader.read(quoteContext);
        if (cur == 44 || cur == matchEnd) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> dict = new HashMap<String, String>();
        for (i = 0; i < context; ++i) {
            cur = reader.read();
        }
        reader.initBuffer();
        while (true) {
            if (cur == 92 || cur == 34) {
                cur = reader.read(quoteContext);
                if (cur != 61) {
                    for (i = 0; i < quoteContext - 1; ++i) {
                        cur = reader.read();
                    }
                }
            } else {
                reader.addToBuffer((char)cur);
                reader.fillUntil('\\', '\"');
                cur = reader.read();
                if (cur != -1) continue;
            }
            String name = reader.bufferToString();
            cur = reader.read(2);
            if (cur == 78) {
                dict.put(name, null);
                cur = reader.read(4);
                if (cur == 92 || cur == 34) {
                    reader.read(context);
                    return dict;
                }
                if (cur == 44 && reader.peek() != 32) {
                    return dict;
                }
                while ((cur = reader.read()) == 32) {
                }
            } else {
                cur = reader.read(quoteContext);
                do {
                    if (cur == 92 || cur == 34) {
                        int i2;
                        cur = reader.read(quoteContext);
                        if (cur == 44) {
                            dict.put(name, reader.bufferToString());
                            while ((cur = reader.read()) == 32) {
                            }
                            cur = reader.read(quoteContext);
                            break;
                        }
                        for (i2 = 0; i2 < context; ++i2) {
                            cur = reader.read();
                        }
                        if (cur == 44 || cur == -1 || cur == matchEnd) {
                            dict.put(name, reader.bufferToString());
                            return dict;
                        }
                        for (i2 = 0; i2 < context - 1; ++i2) {
                            cur = reader.read();
                        }
                    }
                    reader.addToBuffer((char)cur);
                    reader.fillUntil('\\', '\"');
                } while ((cur = reader.read()) != -1);
            }
            if (cur == -1) break;
        }
        return dict;
    }

    public static List<Map<String, String>> parseCollection(PostgresReader reader, int context, boolean allowNulls) throws IOException {
        boolean escaped;
        int cur = reader.read();
        if (cur == 44 || cur == 41) {
            return null;
        }
        boolean bl = escaped = cur != 123;
        if (escaped) {
            reader.read(context);
        }
        int innerContext = context == 0 ? 1 : context << 1;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        cur = reader.peek();
        if (cur == 125) {
            reader.read();
        }
        while (cur != -1 && cur != 125) {
            cur = reader.read();
            if (cur == 78) {
                cur = reader.read(4);
                list.add(allowNulls ? null : new HashMap());
                continue;
            }
            list.add(HstoreConverter.parseMap(reader, innerContext, innerContext << 1, '}'));
            cur = reader.last();
        }
        if (escaped) {
            reader.read(context + 1);
        } else {
            reader.read();
        }
        return list;
    }

    public static PostgresTuple toTuple(Map<String, String> value) {
        if (value == null) {
            return null;
        }
        return new MapTuple(value);
    }

    static class MapTuple
    extends PostgresTuple {
        private final Map<String, String> value;

        public MapTuple(Map<String, String> value) {
            this.value = value;
        }

        @Override
        public boolean mustEscapeRecord() {
            return true;
        }

        @Override
        public boolean mustEscapeArray() {
            return true;
        }

        @Override
        public void insertRecord(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            String esc = MapTuple.buildQuoteEscape(escaping);
            String quoteEscape = MapTuple.buildQuoteEscape(escaping + "0");
            String slashEscape = MapTuple.buildSlashEscape(escaping.length() + 1);
            int len = this.value.size();
            if (mappings != null) {
                for (Map.Entry<String, String> kv : this.value.entrySet()) {
                    int x;
                    --len;
                    for (int x2 = 0; x2 < esc.length(); ++x2) {
                        mappings.map(sw, esc.charAt(x2));
                    }
                    String key = kv.getKey();
                    for (int i = 0; i < key.length(); ++i) {
                        int x3;
                        char c = key.charAt(i);
                        if (c == '\"') {
                            for (x3 = 0; x3 < quoteEscape.length(); ++x3) {
                                mappings.map(sw, quoteEscape.charAt(x3));
                            }
                            continue;
                        }
                        if (c == '\\') {
                            for (x3 = 0; x3 < slashEscape.length(); ++x3) {
                                mappings.map(sw, slashEscape.charAt(x3));
                            }
                            continue;
                        }
                        mappings.map(sw, c);
                    }
                    for (x = 0; x < esc.length(); ++x) {
                        mappings.map(sw, esc.charAt(x));
                    }
                    sw.write("=>");
                    if (kv.getKey() == null) {
                        sw.write("NULL");
                    } else {
                        for (x = 0; x < esc.length(); ++x) {
                            mappings.map(sw, esc.charAt(x));
                        }
                        String val = kv.getValue();
                        for (int i = 0; i < val.length(); ++i) {
                            int x4;
                            char c = val.charAt(i);
                            if (c == '\"') {
                                for (x4 = 0; x4 < quoteEscape.length(); ++x4) {
                                    mappings.map(sw, quoteEscape.charAt(x4));
                                }
                                continue;
                            }
                            if (c == '\\') {
                                for (x4 = 0; x4 < slashEscape.length(); ++x4) {
                                    mappings.map(sw, slashEscape.charAt(x4));
                                }
                                continue;
                            }
                            mappings.map(sw, c);
                        }
                        for (int x5 = 0; x5 < esc.length(); ++x5) {
                            mappings.map(sw, esc.charAt(x5));
                        }
                    }
                    if (len <= 0) continue;
                    sw.write(", ");
                }
            } else {
                for (Map.Entry<String, String> kv : this.value.entrySet()) {
                    --len;
                    sw.write(esc);
                    String key = kv.getKey();
                    for (int i = 0; i < key.length(); ++i) {
                        char c = key.charAt(i);
                        if (c == '\"') {
                            sw.write(quoteEscape);
                            continue;
                        }
                        if (c == '\\') {
                            sw.write(slashEscape);
                            continue;
                        }
                        sw.write(c);
                    }
                    sw.write(esc);
                    sw.write("=>");
                    if (kv.getValue() == null) {
                        sw.write("NULL");
                    } else {
                        sw.write(esc);
                        String val = kv.getValue();
                        for (int i = 0; i < val.length(); ++i) {
                            char c = val.charAt(i);
                            if (c == '\"') {
                                sw.write(quoteEscape);
                                continue;
                            }
                            if (c == '\\') {
                                sw.write(slashEscape);
                                continue;
                            }
                            sw.write(c);
                        }
                        sw.write(esc);
                    }
                    if (len <= 0) continue;
                    sw.write(", ");
                }
            }
        }

        @Override
        public void insertArray(PostgresWriter sw, String escaping, PostgresTuple.Mapping mappings) {
            this.insertRecord(sw, escaping, mappings);
        }
    }
}

